/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.transform.SchemaFacetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SchemaFacet
implements StructuredPojo,
ToCopyableBuilder<Builder, SchemaFacet> {
    private final String schemaArn;
    private final String facetName;

    private SchemaFacet(BuilderImpl builder) {
        this.schemaArn = builder.schemaArn;
        this.facetName = builder.facetName;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String facetName() {
        return this.facetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.schemaArn() == null ? 0 : this.schemaArn().hashCode());
        hashCode = 31 * hashCode + (this.facetName() == null ? 0 : this.facetName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaFacet)) {
            return false;
        }
        SchemaFacet other = (SchemaFacet)obj;
        if (other.schemaArn() == null ^ this.schemaArn() == null) {
            return false;
        }
        if (other.schemaArn() != null && !other.schemaArn().equals(this.schemaArn())) {
            return false;
        }
        if (other.facetName() == null ^ this.facetName() == null) {
            return false;
        }
        return other.facetName() == null || other.facetName().equals(this.facetName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.schemaArn() != null) {
            sb.append("SchemaArn: ").append(this.schemaArn()).append(",");
        }
        if (this.facetName() != null) {
            sb.append("FacetName: ").append(this.facetName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArn": {
                return Optional.of(clazz.cast(this.schemaArn()));
            }
            case "FacetName": {
                return Optional.of(clazz.cast(this.facetName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SchemaFacetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String schemaArn;
        private String facetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaFacet model) {
            this.schemaArn(model.schemaArn);
            this.facetName(model.facetName);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getFacetName() {
            return this.facetName;
        }

        @Override
        public final Builder facetName(String facetName) {
            this.facetName = facetName;
            return this;
        }

        public final void setFacetName(String facetName) {
            this.facetName = facetName;
        }

        public SchemaFacet build() {
            return new SchemaFacet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SchemaFacet> {
        public Builder schemaArn(String var1);

        public Builder facetName(String var1);
    }
}

