/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKey;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeAction;
import software.amazon.awssdk.services.clouddirectory.transform.ObjectAttributeUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ObjectAttributeUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ObjectAttributeUpdate> {
    private final AttributeKey objectAttributeKey;
    private final ObjectAttributeAction objectAttributeAction;

    private ObjectAttributeUpdate(BuilderImpl builder) {
        this.objectAttributeKey = builder.objectAttributeKey;
        this.objectAttributeAction = builder.objectAttributeAction;
    }

    public AttributeKey objectAttributeKey() {
        return this.objectAttributeKey;
    }

    public ObjectAttributeAction objectAttributeAction() {
        return this.objectAttributeAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.objectAttributeKey() == null ? 0 : this.objectAttributeKey().hashCode());
        hashCode = 31 * hashCode + (this.objectAttributeAction() == null ? 0 : this.objectAttributeAction().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectAttributeUpdate)) {
            return false;
        }
        ObjectAttributeUpdate other = (ObjectAttributeUpdate)obj;
        if (other.objectAttributeKey() == null ^ this.objectAttributeKey() == null) {
            return false;
        }
        if (other.objectAttributeKey() != null && !other.objectAttributeKey().equals(this.objectAttributeKey())) {
            return false;
        }
        if (other.objectAttributeAction() == null ^ this.objectAttributeAction() == null) {
            return false;
        }
        return other.objectAttributeAction() == null || other.objectAttributeAction().equals(this.objectAttributeAction());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.objectAttributeKey() != null) {
            sb.append("ObjectAttributeKey: ").append(this.objectAttributeKey()).append(",");
        }
        if (this.objectAttributeAction() != null) {
            sb.append("ObjectAttributeAction: ").append(this.objectAttributeAction()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectAttributeKey": {
                return Optional.of(clazz.cast(this.objectAttributeKey()));
            }
            case "ObjectAttributeAction": {
                return Optional.of(clazz.cast(this.objectAttributeAction()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ObjectAttributeUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AttributeKey objectAttributeKey;
        private ObjectAttributeAction objectAttributeAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectAttributeUpdate model) {
            this.objectAttributeKey(model.objectAttributeKey);
            this.objectAttributeAction(model.objectAttributeAction);
        }

        public final AttributeKey.Builder getObjectAttributeKey() {
            return this.objectAttributeKey != null ? this.objectAttributeKey.toBuilder() : null;
        }

        @Override
        public final Builder objectAttributeKey(AttributeKey objectAttributeKey) {
            this.objectAttributeKey = objectAttributeKey;
            return this;
        }

        public final void setObjectAttributeKey(AttributeKey.BuilderImpl objectAttributeKey) {
            this.objectAttributeKey = objectAttributeKey != null ? objectAttributeKey.build() : null;
        }

        public final ObjectAttributeAction.Builder getObjectAttributeAction() {
            return this.objectAttributeAction != null ? this.objectAttributeAction.toBuilder() : null;
        }

        @Override
        public final Builder objectAttributeAction(ObjectAttributeAction objectAttributeAction) {
            this.objectAttributeAction = objectAttributeAction;
            return this;
        }

        public final void setObjectAttributeAction(ObjectAttributeAction.BuilderImpl objectAttributeAction) {
            this.objectAttributeAction = objectAttributeAction != null ? objectAttributeAction.build() : null;
        }

        public ObjectAttributeUpdate build() {
            return new ObjectAttributeUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ObjectAttributeUpdate> {
        public Builder objectAttributeKey(AttributeKey var1);

        public Builder objectAttributeAction(ObjectAttributeAction var1);
    }
}

