/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinitionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTypedLinkFacetAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTypedLinkFacetAttributesResponse> {
    private final List<TypedLinkAttributeDefinition> attributes;
    private final String nextToken;

    private ListTypedLinkFacetAttributesResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.nextToken = builder.nextToken;
    }

    public List<TypedLinkAttributeDefinition> attributes() {
        return this.attributes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypedLinkFacetAttributesResponse)) {
            return false;
        }
        ListTypedLinkFacetAttributesResponse other = (ListTypedLinkFacetAttributesResponse)((Object)obj);
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<TypedLinkAttributeDefinition> attributes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypedLinkFacetAttributesResponse model) {
            this.attributes(model.attributes);
            this.nextToken(model.nextToken);
        }

        public final Collection<TypedLinkAttributeDefinition.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(TypedLinkAttributeDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<TypedLinkAttributeDefinition> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TypedLinkAttributeDefinition ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<TypedLinkAttributeDefinition.BuilderImpl> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copyFromBuilder(attributes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListTypedLinkFacetAttributesResponse build() {
            return new ListTypedLinkFacetAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTypedLinkFacetAttributesResponse> {
        public Builder attributes(Collection<TypedLinkAttributeDefinition> var1);

        public Builder attributes(TypedLinkAttributeDefinition ... var1);

        public Builder nextToken(String var1);
    }
}

