/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListObjectPoliciesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListObjectPoliciesResponse> {
    private final List<String> attachedPolicyIds;
    private final String nextToken;

    private ListObjectPoliciesResponse(BuilderImpl builder) {
        this.attachedPolicyIds = builder.attachedPolicyIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> attachedPolicyIds() {
        return this.attachedPolicyIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attachedPolicyIds() == null ? 0 : this.attachedPolicyIds().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectPoliciesResponse)) {
            return false;
        }
        ListObjectPoliciesResponse other = (ListObjectPoliciesResponse)((Object)obj);
        if (other.attachedPolicyIds() == null ^ this.attachedPolicyIds() == null) {
            return false;
        }
        if (other.attachedPolicyIds() != null && !other.attachedPolicyIds().equals(this.attachedPolicyIds())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attachedPolicyIds() != null) {
            sb.append("AttachedPolicyIds: ").append(this.attachedPolicyIds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachedPolicyIds": {
                return Optional.of(clazz.cast(this.attachedPolicyIds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> attachedPolicyIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectPoliciesResponse model) {
            this.attachedPolicyIds(model.attachedPolicyIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAttachedPolicyIds() {
            return this.attachedPolicyIds;
        }

        @Override
        public final Builder attachedPolicyIds(Collection<String> attachedPolicyIds) {
            this.attachedPolicyIds = ObjectIdentifierListCopier.copy(attachedPolicyIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedPolicyIds(String ... attachedPolicyIds) {
            this.attachedPolicyIds(Arrays.asList(attachedPolicyIds));
            return this;
        }

        public final void setAttachedPolicyIds(Collection<String> attachedPolicyIds) {
            this.attachedPolicyIds = ObjectIdentifierListCopier.copy(attachedPolicyIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListObjectPoliciesResponse build() {
            return new ListObjectPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListObjectPoliciesResponse> {
        public Builder attachedPolicyIds(Collection<String> var1);

        public Builder attachedPolicyIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

