/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectType;
import software.amazon.awssdk.services.clouddirectory.transform.FacetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Facet
implements StructuredPojo,
ToCopyableBuilder<Builder, Facet> {
    private final String name;
    private final String objectType;

    private Facet(BuilderImpl builder) {
        this.name = builder.name;
        this.objectType = builder.objectType;
    }

    public String name() {
        return this.name;
    }

    public ObjectType objectType() {
        return ObjectType.fromValue(this.objectType);
    }

    public String objectTypeString() {
        return this.objectType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.objectTypeString() == null ? 0 : this.objectTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Facet)) {
            return false;
        }
        Facet other = (Facet)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.objectTypeString() == null ^ this.objectTypeString() == null) {
            return false;
        }
        return other.objectTypeString() == null || other.objectTypeString().equals(this.objectTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.objectTypeString() != null) {
            sb.append("ObjectType: ").append(this.objectTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ObjectType": {
                return Optional.of(clazz.cast(this.objectTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FacetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String objectType;

        private BuilderImpl() {
        }

        private BuilderImpl(Facet model) {
            this.name(model.name);
            this.objectType(model.objectType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getObjectType() {
            return this.objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectType objectType) {
            this.objectType(objectType.toString());
            return this;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public Facet build() {
            return new Facet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Facet> {
        public Builder name(String var1);

        public Builder objectType(String var1);

        public Builder objectType(ObjectType var1);
    }
}

