/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryState;
import software.amazon.awssdk.services.clouddirectory.transform.DirectoryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Directory
implements StructuredPojo,
ToCopyableBuilder<Builder, Directory> {
    private final String name;
    private final String directoryArn;
    private final String state;
    private final Instant creationDateTime;

    private Directory(BuilderImpl builder) {
        this.name = builder.name;
        this.directoryArn = builder.directoryArn;
        this.state = builder.state;
        this.creationDateTime = builder.creationDateTime;
    }

    public String name() {
        return this.name;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public DirectoryState state() {
        return DirectoryState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.directoryArn() == null ? 0 : this.directoryArn().hashCode());
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.creationDateTime() == null ? 0 : this.creationDateTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Directory)) {
            return false;
        }
        Directory other = (Directory)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.directoryArn() == null ^ this.directoryArn() == null) {
            return false;
        }
        if (other.directoryArn() != null && !other.directoryArn().equals(this.directoryArn())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.creationDateTime() == null ^ this.creationDateTime() == null) {
            return false;
        }
        return other.creationDateTime() == null || other.creationDateTime().equals(this.creationDateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.creationDateTime() != null) {
            sb.append("CreationDateTime: ").append(this.creationDateTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "CreationDateTime": {
                return Optional.of(clazz.cast(this.creationDateTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DirectoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String directoryArn;
        private String state;
        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Directory model) {
            this.name(model.name);
            this.directoryArn(model.directoryArn);
            this.state(model.state);
            this.creationDateTime(model.creationDateTime);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DirectoryState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public Directory build() {
            return new Directory(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Directory> {
        public Builder name(String var1);

        public Builder directoryArn(String var1);

        public Builder state(String var1);

        public Builder state(DirectoryState var1);

        public Builder creationDateTime(Instant var1);
    }
}

