/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetachObjectRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DetachObjectRequest> {
    private final String directoryArn;
    private final ObjectReference parentReference;
    private final String linkName;

    private DetachObjectRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public String linkName() {
        return this.linkName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.directoryArn() == null ? 0 : this.directoryArn().hashCode());
        hashCode = 31 * hashCode + (this.parentReference() == null ? 0 : this.parentReference().hashCode());
        hashCode = 31 * hashCode + (this.linkName() == null ? 0 : this.linkName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachObjectRequest)) {
            return false;
        }
        DetachObjectRequest other = (DetachObjectRequest)((Object)obj);
        if (other.directoryArn() == null ^ this.directoryArn() == null) {
            return false;
        }
        if (other.directoryArn() != null && !other.directoryArn().equals(this.directoryArn())) {
            return false;
        }
        if (other.parentReference() == null ^ this.parentReference() == null) {
            return false;
        }
        if (other.parentReference() != null && !other.parentReference().equals(this.parentReference())) {
            return false;
        }
        if (other.linkName() == null ^ this.linkName() == null) {
            return false;
        }
        return other.linkName() == null || other.linkName().equals(this.linkName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.parentReference() != null) {
            sb.append("ParentReference: ").append(this.parentReference()).append(",");
        }
        if (this.linkName() != null) {
            sb.append("LinkName: ").append(this.linkName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
            case "ParentReference": {
                return Optional.of(clazz.cast(this.parentReference()));
            }
            case "LinkName": {
                return Optional.of(clazz.cast(this.linkName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference parentReference;
        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachObjectRequest model) {
            this.directoryArn(model.directoryArn);
            this.parentReference(model.parentReference);
            this.linkName(model.linkName);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public DetachObjectRequest build() {
            return new DetachObjectRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetachObjectRequest> {
        public Builder directoryArn(String var1);

        public Builder parentReference(ObjectReference var1);

        public Builder linkName(String var1);
    }
}

