/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetachFromIndexRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DetachFromIndexRequest> {
    private final String directoryArn;
    private final ObjectReference indexReference;
    private final ObjectReference targetReference;

    private DetachFromIndexRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.indexReference = builder.indexReference;
        this.targetReference = builder.targetReference;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference indexReference() {
        return this.indexReference;
    }

    public ObjectReference targetReference() {
        return this.targetReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.directoryArn() == null ? 0 : this.directoryArn().hashCode());
        hashCode = 31 * hashCode + (this.indexReference() == null ? 0 : this.indexReference().hashCode());
        hashCode = 31 * hashCode + (this.targetReference() == null ? 0 : this.targetReference().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachFromIndexRequest)) {
            return false;
        }
        DetachFromIndexRequest other = (DetachFromIndexRequest)((Object)obj);
        if (other.directoryArn() == null ^ this.directoryArn() == null) {
            return false;
        }
        if (other.directoryArn() != null && !other.directoryArn().equals(this.directoryArn())) {
            return false;
        }
        if (other.indexReference() == null ^ this.indexReference() == null) {
            return false;
        }
        if (other.indexReference() != null && !other.indexReference().equals(this.indexReference())) {
            return false;
        }
        if (other.targetReference() == null ^ this.targetReference() == null) {
            return false;
        }
        return other.targetReference() == null || other.targetReference().equals(this.targetReference());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.indexReference() != null) {
            sb.append("IndexReference: ").append(this.indexReference()).append(",");
        }
        if (this.targetReference() != null) {
            sb.append("TargetReference: ").append(this.targetReference()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
            case "IndexReference": {
                return Optional.of(clazz.cast(this.indexReference()));
            }
            case "TargetReference": {
                return Optional.of(clazz.cast(this.targetReference()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference indexReference;
        private ObjectReference targetReference;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachFromIndexRequest model) {
            this.directoryArn(model.directoryArn);
            this.indexReference(model.indexReference);
            this.targetReference(model.targetReference);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getIndexReference() {
            return this.indexReference != null ? this.indexReference.toBuilder() : null;
        }

        @Override
        public final Builder indexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
            return this;
        }

        public final void setIndexReference(ObjectReference.BuilderImpl indexReference) {
            this.indexReference = indexReference != null ? indexReference.build() : null;
        }

        public final ObjectReference.Builder getTargetReference() {
            return this.targetReference != null ? this.targetReference.toBuilder() : null;
        }

        @Override
        public final Builder targetReference(ObjectReference targetReference) {
            this.targetReference = targetReference;
            return this;
        }

        public final void setTargetReference(ObjectReference.BuilderImpl targetReference) {
            this.targetReference = targetReference != null ? targetReference.build() : null;
        }

        public DetachFromIndexRequest build() {
            return new DetachFromIndexRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetachFromIndexRequest> {
        public Builder directoryArn(String var1);

        public Builder indexReference(ObjectReference var1);

        public Builder targetReference(ObjectReference var1);
    }
}

