/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchCreateObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchDeleteObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchRemoveFacetFromObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributes;
import software.amazon.awssdk.services.clouddirectory.transform.BatchWriteOperationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchWriteOperation
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchWriteOperation> {
    private final BatchCreateObject createObject;
    private final BatchAttachObject attachObject;
    private final BatchDetachObject detachObject;
    private final BatchUpdateObjectAttributes updateObjectAttributes;
    private final BatchDeleteObject deleteObject;
    private final BatchAddFacetToObject addFacetToObject;
    private final BatchRemoveFacetFromObject removeFacetFromObject;

    private BatchWriteOperation(BuilderImpl builder) {
        this.createObject = builder.createObject;
        this.attachObject = builder.attachObject;
        this.detachObject = builder.detachObject;
        this.updateObjectAttributes = builder.updateObjectAttributes;
        this.deleteObject = builder.deleteObject;
        this.addFacetToObject = builder.addFacetToObject;
        this.removeFacetFromObject = builder.removeFacetFromObject;
    }

    public BatchCreateObject createObject() {
        return this.createObject;
    }

    public BatchAttachObject attachObject() {
        return this.attachObject;
    }

    public BatchDetachObject detachObject() {
        return this.detachObject;
    }

    public BatchUpdateObjectAttributes updateObjectAttributes() {
        return this.updateObjectAttributes;
    }

    public BatchDeleteObject deleteObject() {
        return this.deleteObject;
    }

    public BatchAddFacetToObject addFacetToObject() {
        return this.addFacetToObject;
    }

    public BatchRemoveFacetFromObject removeFacetFromObject() {
        return this.removeFacetFromObject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.createObject() == null ? 0 : this.createObject().hashCode());
        hashCode = 31 * hashCode + (this.attachObject() == null ? 0 : this.attachObject().hashCode());
        hashCode = 31 * hashCode + (this.detachObject() == null ? 0 : this.detachObject().hashCode());
        hashCode = 31 * hashCode + (this.updateObjectAttributes() == null ? 0 : this.updateObjectAttributes().hashCode());
        hashCode = 31 * hashCode + (this.deleteObject() == null ? 0 : this.deleteObject().hashCode());
        hashCode = 31 * hashCode + (this.addFacetToObject() == null ? 0 : this.addFacetToObject().hashCode());
        hashCode = 31 * hashCode + (this.removeFacetFromObject() == null ? 0 : this.removeFacetFromObject().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteOperation)) {
            return false;
        }
        BatchWriteOperation other = (BatchWriteOperation)obj;
        if (other.createObject() == null ^ this.createObject() == null) {
            return false;
        }
        if (other.createObject() != null && !other.createObject().equals(this.createObject())) {
            return false;
        }
        if (other.attachObject() == null ^ this.attachObject() == null) {
            return false;
        }
        if (other.attachObject() != null && !other.attachObject().equals(this.attachObject())) {
            return false;
        }
        if (other.detachObject() == null ^ this.detachObject() == null) {
            return false;
        }
        if (other.detachObject() != null && !other.detachObject().equals(this.detachObject())) {
            return false;
        }
        if (other.updateObjectAttributes() == null ^ this.updateObjectAttributes() == null) {
            return false;
        }
        if (other.updateObjectAttributes() != null && !other.updateObjectAttributes().equals(this.updateObjectAttributes())) {
            return false;
        }
        if (other.deleteObject() == null ^ this.deleteObject() == null) {
            return false;
        }
        if (other.deleteObject() != null && !other.deleteObject().equals(this.deleteObject())) {
            return false;
        }
        if (other.addFacetToObject() == null ^ this.addFacetToObject() == null) {
            return false;
        }
        if (other.addFacetToObject() != null && !other.addFacetToObject().equals(this.addFacetToObject())) {
            return false;
        }
        if (other.removeFacetFromObject() == null ^ this.removeFacetFromObject() == null) {
            return false;
        }
        return other.removeFacetFromObject() == null || other.removeFacetFromObject().equals(this.removeFacetFromObject());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.createObject() != null) {
            sb.append("CreateObject: ").append(this.createObject()).append(",");
        }
        if (this.attachObject() != null) {
            sb.append("AttachObject: ").append(this.attachObject()).append(",");
        }
        if (this.detachObject() != null) {
            sb.append("DetachObject: ").append(this.detachObject()).append(",");
        }
        if (this.updateObjectAttributes() != null) {
            sb.append("UpdateObjectAttributes: ").append(this.updateObjectAttributes()).append(",");
        }
        if (this.deleteObject() != null) {
            sb.append("DeleteObject: ").append(this.deleteObject()).append(",");
        }
        if (this.addFacetToObject() != null) {
            sb.append("AddFacetToObject: ").append(this.addFacetToObject()).append(",");
        }
        if (this.removeFacetFromObject() != null) {
            sb.append("RemoveFacetFromObject: ").append(this.removeFacetFromObject()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateObject": {
                return Optional.of(clazz.cast(this.createObject()));
            }
            case "AttachObject": {
                return Optional.of(clazz.cast(this.attachObject()));
            }
            case "DetachObject": {
                return Optional.of(clazz.cast(this.detachObject()));
            }
            case "UpdateObjectAttributes": {
                return Optional.of(clazz.cast(this.updateObjectAttributes()));
            }
            case "DeleteObject": {
                return Optional.of(clazz.cast(this.deleteObject()));
            }
            case "AddFacetToObject": {
                return Optional.of(clazz.cast(this.addFacetToObject()));
            }
            case "RemoveFacetFromObject": {
                return Optional.of(clazz.cast(this.removeFacetFromObject()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchWriteOperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BatchCreateObject createObject;
        private BatchAttachObject attachObject;
        private BatchDetachObject detachObject;
        private BatchUpdateObjectAttributes updateObjectAttributes;
        private BatchDeleteObject deleteObject;
        private BatchAddFacetToObject addFacetToObject;
        private BatchRemoveFacetFromObject removeFacetFromObject;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteOperation model) {
            this.createObject(model.createObject);
            this.attachObject(model.attachObject);
            this.detachObject(model.detachObject);
            this.updateObjectAttributes(model.updateObjectAttributes);
            this.deleteObject(model.deleteObject);
            this.addFacetToObject(model.addFacetToObject);
            this.removeFacetFromObject(model.removeFacetFromObject);
        }

        public final BatchCreateObject.Builder getCreateObject() {
            return this.createObject != null ? this.createObject.toBuilder() : null;
        }

        @Override
        public final Builder createObject(BatchCreateObject createObject) {
            this.createObject = createObject;
            return this;
        }

        public final void setCreateObject(BatchCreateObject.BuilderImpl createObject) {
            this.createObject = createObject != null ? createObject.build() : null;
        }

        public final BatchAttachObject.Builder getAttachObject() {
            return this.attachObject != null ? this.attachObject.toBuilder() : null;
        }

        @Override
        public final Builder attachObject(BatchAttachObject attachObject) {
            this.attachObject = attachObject;
            return this;
        }

        public final void setAttachObject(BatchAttachObject.BuilderImpl attachObject) {
            this.attachObject = attachObject != null ? attachObject.build() : null;
        }

        public final BatchDetachObject.Builder getDetachObject() {
            return this.detachObject != null ? this.detachObject.toBuilder() : null;
        }

        @Override
        public final Builder detachObject(BatchDetachObject detachObject) {
            this.detachObject = detachObject;
            return this;
        }

        public final void setDetachObject(BatchDetachObject.BuilderImpl detachObject) {
            this.detachObject = detachObject != null ? detachObject.build() : null;
        }

        public final BatchUpdateObjectAttributes.Builder getUpdateObjectAttributes() {
            return this.updateObjectAttributes != null ? this.updateObjectAttributes.toBuilder() : null;
        }

        @Override
        public final Builder updateObjectAttributes(BatchUpdateObjectAttributes updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes;
            return this;
        }

        public final void setUpdateObjectAttributes(BatchUpdateObjectAttributes.BuilderImpl updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes != null ? updateObjectAttributes.build() : null;
        }

        public final BatchDeleteObject.Builder getDeleteObject() {
            return this.deleteObject != null ? this.deleteObject.toBuilder() : null;
        }

        @Override
        public final Builder deleteObject(BatchDeleteObject deleteObject) {
            this.deleteObject = deleteObject;
            return this;
        }

        public final void setDeleteObject(BatchDeleteObject.BuilderImpl deleteObject) {
            this.deleteObject = deleteObject != null ? deleteObject.build() : null;
        }

        public final BatchAddFacetToObject.Builder getAddFacetToObject() {
            return this.addFacetToObject != null ? this.addFacetToObject.toBuilder() : null;
        }

        @Override
        public final Builder addFacetToObject(BatchAddFacetToObject addFacetToObject) {
            this.addFacetToObject = addFacetToObject;
            return this;
        }

        public final void setAddFacetToObject(BatchAddFacetToObject.BuilderImpl addFacetToObject) {
            this.addFacetToObject = addFacetToObject != null ? addFacetToObject.build() : null;
        }

        public final BatchRemoveFacetFromObject.Builder getRemoveFacetFromObject() {
            return this.removeFacetFromObject != null ? this.removeFacetFromObject.toBuilder() : null;
        }

        @Override
        public final Builder removeFacetFromObject(BatchRemoveFacetFromObject removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject;
            return this;
        }

        public final void setRemoveFacetFromObject(BatchRemoveFacetFromObject.BuilderImpl removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject != null ? removeFacetFromObject.build() : null;
        }

        public BatchWriteOperation build() {
            return new BatchWriteOperation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchWriteOperation> {
        public Builder createObject(BatchCreateObject var1);

        public Builder attachObject(BatchAttachObject var1);

        public Builder detachObject(BatchDetachObject var1);

        public Builder updateObjectAttributes(BatchUpdateObjectAttributes var1);

        public Builder deleteObject(BatchDeleteObject var1);

        public Builder addFacetToObject(BatchAddFacetToObject var1);

        public Builder removeFacetFromObject(BatchRemoveFacetFromObject var1);
    }
}

