/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.transform.BatchDetachObjectMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDetachObject
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchDetachObject> {
    private final ObjectReference parentReference;
    private final String linkName;
    private final String batchReferenceName;

    private BatchDetachObject(BuilderImpl builder) {
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
        this.batchReferenceName = builder.batchReferenceName;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public String linkName() {
        return this.linkName;
    }

    public String batchReferenceName() {
        return this.batchReferenceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parentReference() == null ? 0 : this.parentReference().hashCode());
        hashCode = 31 * hashCode + (this.linkName() == null ? 0 : this.linkName().hashCode());
        hashCode = 31 * hashCode + (this.batchReferenceName() == null ? 0 : this.batchReferenceName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetachObject)) {
            return false;
        }
        BatchDetachObject other = (BatchDetachObject)obj;
        if (other.parentReference() == null ^ this.parentReference() == null) {
            return false;
        }
        if (other.parentReference() != null && !other.parentReference().equals(this.parentReference())) {
            return false;
        }
        if (other.linkName() == null ^ this.linkName() == null) {
            return false;
        }
        if (other.linkName() != null && !other.linkName().equals(this.linkName())) {
            return false;
        }
        if (other.batchReferenceName() == null ^ this.batchReferenceName() == null) {
            return false;
        }
        return other.batchReferenceName() == null || other.batchReferenceName().equals(this.batchReferenceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parentReference() != null) {
            sb.append("ParentReference: ").append(this.parentReference()).append(",");
        }
        if (this.linkName() != null) {
            sb.append("LinkName: ").append(this.linkName()).append(",");
        }
        if (this.batchReferenceName() != null) {
            sb.append("BatchReferenceName: ").append(this.batchReferenceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentReference": {
                return Optional.of(clazz.cast(this.parentReference()));
            }
            case "LinkName": {
                return Optional.of(clazz.cast(this.linkName()));
            }
            case "BatchReferenceName": {
                return Optional.of(clazz.cast(this.batchReferenceName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchDetachObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference parentReference;
        private String linkName;
        private String batchReferenceName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetachObject model) {
            this.parentReference(model.parentReference);
            this.linkName(model.linkName);
            this.batchReferenceName(model.batchReferenceName);
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public final String getBatchReferenceName() {
            return this.batchReferenceName;
        }

        @Override
        public final Builder batchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
            return this;
        }

        public final void setBatchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
        }

        public BatchDetachObject build() {
            return new BatchDetachObject(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchDetachObject> {
        public Builder parentReference(ObjectReference var1);

        public Builder linkName(String var1);

        public Builder batchReferenceName(String var1);
    }
}

