/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.transform.BatchAttachObjectMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchAttachObject
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchAttachObject> {
    private final ObjectReference parentReference;
    private final ObjectReference childReference;
    private final String linkName;

    private BatchAttachObject(BuilderImpl builder) {
        this.parentReference = builder.parentReference;
        this.childReference = builder.childReference;
        this.linkName = builder.linkName;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public ObjectReference childReference() {
        return this.childReference;
    }

    public String linkName() {
        return this.linkName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parentReference() == null ? 0 : this.parentReference().hashCode());
        hashCode = 31 * hashCode + (this.childReference() == null ? 0 : this.childReference().hashCode());
        hashCode = 31 * hashCode + (this.linkName() == null ? 0 : this.linkName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAttachObject)) {
            return false;
        }
        BatchAttachObject other = (BatchAttachObject)obj;
        if (other.parentReference() == null ^ this.parentReference() == null) {
            return false;
        }
        if (other.parentReference() != null && !other.parentReference().equals(this.parentReference())) {
            return false;
        }
        if (other.childReference() == null ^ this.childReference() == null) {
            return false;
        }
        if (other.childReference() != null && !other.childReference().equals(this.childReference())) {
            return false;
        }
        if (other.linkName() == null ^ this.linkName() == null) {
            return false;
        }
        return other.linkName() == null || other.linkName().equals(this.linkName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parentReference() != null) {
            sb.append("ParentReference: ").append(this.parentReference()).append(",");
        }
        if (this.childReference() != null) {
            sb.append("ChildReference: ").append(this.childReference()).append(",");
        }
        if (this.linkName() != null) {
            sb.append("LinkName: ").append(this.linkName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentReference": {
                return Optional.of(clazz.cast(this.parentReference()));
            }
            case "ChildReference": {
                return Optional.of(clazz.cast(this.childReference()));
            }
            case "LinkName": {
                return Optional.of(clazz.cast(this.linkName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchAttachObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference parentReference;
        private ObjectReference childReference;
        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAttachObject model) {
            this.parentReference(model.parentReference);
            this.childReference(model.childReference);
            this.linkName(model.linkName);
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final ObjectReference.Builder getChildReference() {
            return this.childReference != null ? this.childReference.toBuilder() : null;
        }

        @Override
        public final Builder childReference(ObjectReference childReference) {
            this.childReference = childReference;
            return this;
        }

        public final void setChildReference(ObjectReference.BuilderImpl childReference) {
            this.childReference = childReference != null ? childReference.build() : null;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public BatchAttachObject build() {
            return new BatchAttachObject(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchAttachObject> {
        public Builder parentReference(ObjectReference var1);

        public Builder childReference(ObjectReference var1);

        public Builder linkName(String var1);
    }
}

