/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachTypedLinkRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AttachTypedLinkRequest> {
    private final String directoryArn;
    private final ObjectReference sourceObjectReference;
    private final ObjectReference targetObjectReference;
    private final TypedLinkSchemaAndFacetName typedLinkFacet;
    private final List<AttributeNameAndValue> attributes;

    private AttachTypedLinkRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.sourceObjectReference = builder.sourceObjectReference;
        this.targetObjectReference = builder.targetObjectReference;
        this.typedLinkFacet = builder.typedLinkFacet;
        this.attributes = builder.attributes;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference sourceObjectReference() {
        return this.sourceObjectReference;
    }

    public ObjectReference targetObjectReference() {
        return this.targetObjectReference;
    }

    public TypedLinkSchemaAndFacetName typedLinkFacet() {
        return this.typedLinkFacet;
    }

    public List<AttributeNameAndValue> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.directoryArn() == null ? 0 : this.directoryArn().hashCode());
        hashCode = 31 * hashCode + (this.sourceObjectReference() == null ? 0 : this.sourceObjectReference().hashCode());
        hashCode = 31 * hashCode + (this.targetObjectReference() == null ? 0 : this.targetObjectReference().hashCode());
        hashCode = 31 * hashCode + (this.typedLinkFacet() == null ? 0 : this.typedLinkFacet().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachTypedLinkRequest)) {
            return false;
        }
        AttachTypedLinkRequest other = (AttachTypedLinkRequest)((Object)obj);
        if (other.directoryArn() == null ^ this.directoryArn() == null) {
            return false;
        }
        if (other.directoryArn() != null && !other.directoryArn().equals(this.directoryArn())) {
            return false;
        }
        if (other.sourceObjectReference() == null ^ this.sourceObjectReference() == null) {
            return false;
        }
        if (other.sourceObjectReference() != null && !other.sourceObjectReference().equals(this.sourceObjectReference())) {
            return false;
        }
        if (other.targetObjectReference() == null ^ this.targetObjectReference() == null) {
            return false;
        }
        if (other.targetObjectReference() != null && !other.targetObjectReference().equals(this.targetObjectReference())) {
            return false;
        }
        if (other.typedLinkFacet() == null ^ this.typedLinkFacet() == null) {
            return false;
        }
        if (other.typedLinkFacet() != null && !other.typedLinkFacet().equals(this.typedLinkFacet())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.sourceObjectReference() != null) {
            sb.append("SourceObjectReference: ").append(this.sourceObjectReference()).append(",");
        }
        if (this.targetObjectReference() != null) {
            sb.append("TargetObjectReference: ").append(this.targetObjectReference()).append(",");
        }
        if (this.typedLinkFacet() != null) {
            sb.append("TypedLinkFacet: ").append(this.typedLinkFacet()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
            case "SourceObjectReference": {
                return Optional.of(clazz.cast(this.sourceObjectReference()));
            }
            case "TargetObjectReference": {
                return Optional.of(clazz.cast(this.targetObjectReference()));
            }
            case "TypedLinkFacet": {
                return Optional.of(clazz.cast(this.typedLinkFacet()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference sourceObjectReference;
        private ObjectReference targetObjectReference;
        private TypedLinkSchemaAndFacetName typedLinkFacet;
        private List<AttributeNameAndValue> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachTypedLinkRequest model) {
            this.directoryArn(model.directoryArn);
            this.sourceObjectReference(model.sourceObjectReference);
            this.targetObjectReference(model.targetObjectReference);
            this.typedLinkFacet(model.typedLinkFacet);
            this.attributes(model.attributes);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getSourceObjectReference() {
            return this.sourceObjectReference != null ? this.sourceObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder sourceObjectReference(ObjectReference sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference;
            return this;
        }

        public final void setSourceObjectReference(ObjectReference.BuilderImpl sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference != null ? sourceObjectReference.build() : null;
        }

        public final ObjectReference.Builder getTargetObjectReference() {
            return this.targetObjectReference != null ? this.targetObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder targetObjectReference(ObjectReference targetObjectReference) {
            this.targetObjectReference = targetObjectReference;
            return this;
        }

        public final void setTargetObjectReference(ObjectReference.BuilderImpl targetObjectReference) {
            this.targetObjectReference = targetObjectReference != null ? targetObjectReference.build() : null;
        }

        public final TypedLinkSchemaAndFacetName.Builder getTypedLinkFacet() {
            return this.typedLinkFacet != null ? this.typedLinkFacet.toBuilder() : null;
        }

        @Override
        public final Builder typedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet;
            return this;
        }

        public final void setTypedLinkFacet(TypedLinkSchemaAndFacetName.BuilderImpl typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet != null ? typedLinkFacet.build() : null;
        }

        public final Collection<AttributeNameAndValue.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(AttributeNameAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<AttributeNameAndValue> attributes) {
            this.attributes = AttributeNameAndValueListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeNameAndValue ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<AttributeNameAndValue.BuilderImpl> attributes) {
            this.attributes = AttributeNameAndValueListCopier.copyFromBuilder(attributes);
        }

        public AttachTypedLinkRequest build() {
            return new AttachTypedLinkRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttachTypedLinkRequest> {
        public Builder directoryArn(String var1);

        public Builder sourceObjectReference(ObjectReference var1);

        public Builder targetObjectReference(ObjectReference var1);

        public Builder typedLinkFacet(TypedLinkSchemaAndFacetName var1);

        public Builder attributes(Collection<AttributeNameAndValue> var1);

        public Builder attributes(AttributeNameAndValue ... var1);
    }
}

