/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.IndexAttachment;

@SdkInternalApi
public class IndexAttachmentMarshaller {
    private static final MarshallingInfo<List> INDEXEDATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexedAttributes").build();
    private static final MarshallingInfo<String> OBJECTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectIdentifier").build();
    private static final IndexAttachmentMarshaller INSTANCE = new IndexAttachmentMarshaller();

    public static IndexAttachmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IndexAttachment indexAttachment, ProtocolMarshaller protocolMarshaller) {
        if (indexAttachment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(indexAttachment.indexedAttributes(), INDEXEDATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)indexAttachment.objectIdentifier(), OBJECTIDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

