/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.clouddirectory.model.Directory;

public class DirectoryUnmarshaller
implements Unmarshaller<Directory, JsonUnmarshallerContext> {
    private static final DirectoryUnmarshaller INSTANCE = new DirectoryUnmarshaller();

    public Directory unmarshall(JsonUnmarshallerContext context) throws Exception {
        Directory.Builder directoryBuilder = Directory.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    directoryBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DirectoryArn", targetDepth)) {
                    context.nextToken();
                    directoryBuilder.directoryArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    directoryBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDateTime", targetDepth)) {
                    context.nextToken();
                    directoryBuilder.creationDateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Directory)directoryBuilder.build();
    }

    public static DirectoryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

