/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOutgoingTypedLinksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListOutgoingTypedLinksResponse> {
    private final List<TypedLinkSpecifier> typedLinkSpecifiers;
    private final String nextToken;

    private ListOutgoingTypedLinksResponse(BuilderImpl builder) {
        this.typedLinkSpecifiers = builder.typedLinkSpecifiers;
        this.nextToken = builder.nextToken;
    }

    public List<TypedLinkSpecifier> typedLinkSpecifiers() {
        return this.typedLinkSpecifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typedLinkSpecifiers() == null ? 0 : this.typedLinkSpecifiers().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutgoingTypedLinksResponse)) {
            return false;
        }
        ListOutgoingTypedLinksResponse other = (ListOutgoingTypedLinksResponse)((Object)obj);
        if (other.typedLinkSpecifiers() == null ^ this.typedLinkSpecifiers() == null) {
            return false;
        }
        if (other.typedLinkSpecifiers() != null && !other.typedLinkSpecifiers().equals(this.typedLinkSpecifiers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.typedLinkSpecifiers() != null) {
            sb.append("TypedLinkSpecifiers: ").append(this.typedLinkSpecifiers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TypedLinkSpecifier> typedLinkSpecifiers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutgoingTypedLinksResponse model) {
            this.setTypedLinkSpecifiers(model.typedLinkSpecifiers);
            this.setNextToken(model.nextToken);
        }

        public final Collection<TypedLinkSpecifier> getTypedLinkSpecifiers() {
            return this.typedLinkSpecifiers;
        }

        @Override
        public final Builder typedLinkSpecifiers(Collection<TypedLinkSpecifier> typedLinkSpecifiers) {
            this.typedLinkSpecifiers = TypedLinkSpecifierListCopier.copy(typedLinkSpecifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typedLinkSpecifiers(TypedLinkSpecifier ... typedLinkSpecifiers) {
            this.typedLinkSpecifiers(Arrays.asList(typedLinkSpecifiers));
            return this;
        }

        public final void setTypedLinkSpecifiers(Collection<TypedLinkSpecifier> typedLinkSpecifiers) {
            this.typedLinkSpecifiers = TypedLinkSpecifierListCopier.copy(typedLinkSpecifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListOutgoingTypedLinksResponse build() {
            return new ListOutgoingTypedLinksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListOutgoingTypedLinksResponse> {
        public Builder typedLinkSpecifiers(Collection<TypedLinkSpecifier> var1);

        public Builder typedLinkSpecifiers(TypedLinkSpecifier ... var1);

        public Builder nextToken(String var1);
    }
}

