/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchCreateObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDeleteObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchRemoveFacetFromObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.transform.BatchWriteOperationResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchWriteOperationResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchWriteOperationResponse> {
    private final BatchCreateObjectResponse createObject;
    private final BatchAttachObjectResponse attachObject;
    private final BatchDetachObjectResponse detachObject;
    private final BatchUpdateObjectAttributesResponse updateObjectAttributes;
    private final BatchDeleteObjectResponse deleteObject;
    private final BatchAddFacetToObjectResponse addFacetToObject;
    private final BatchRemoveFacetFromObjectResponse removeFacetFromObject;

    private BatchWriteOperationResponse(BuilderImpl builder) {
        this.createObject = builder.createObject;
        this.attachObject = builder.attachObject;
        this.detachObject = builder.detachObject;
        this.updateObjectAttributes = builder.updateObjectAttributes;
        this.deleteObject = builder.deleteObject;
        this.addFacetToObject = builder.addFacetToObject;
        this.removeFacetFromObject = builder.removeFacetFromObject;
    }

    public BatchCreateObjectResponse createObject() {
        return this.createObject;
    }

    public BatchAttachObjectResponse attachObject() {
        return this.attachObject;
    }

    public BatchDetachObjectResponse detachObject() {
        return this.detachObject;
    }

    public BatchUpdateObjectAttributesResponse updateObjectAttributes() {
        return this.updateObjectAttributes;
    }

    public BatchDeleteObjectResponse deleteObject() {
        return this.deleteObject;
    }

    public BatchAddFacetToObjectResponse addFacetToObject() {
        return this.addFacetToObject;
    }

    public BatchRemoveFacetFromObjectResponse removeFacetFromObject() {
        return this.removeFacetFromObject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.createObject() == null ? 0 : this.createObject().hashCode());
        hashCode = 31 * hashCode + (this.attachObject() == null ? 0 : this.attachObject().hashCode());
        hashCode = 31 * hashCode + (this.detachObject() == null ? 0 : this.detachObject().hashCode());
        hashCode = 31 * hashCode + (this.updateObjectAttributes() == null ? 0 : this.updateObjectAttributes().hashCode());
        hashCode = 31 * hashCode + (this.deleteObject() == null ? 0 : this.deleteObject().hashCode());
        hashCode = 31 * hashCode + (this.addFacetToObject() == null ? 0 : this.addFacetToObject().hashCode());
        hashCode = 31 * hashCode + (this.removeFacetFromObject() == null ? 0 : this.removeFacetFromObject().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteOperationResponse)) {
            return false;
        }
        BatchWriteOperationResponse other = (BatchWriteOperationResponse)obj;
        if (other.createObject() == null ^ this.createObject() == null) {
            return false;
        }
        if (other.createObject() != null && !other.createObject().equals(this.createObject())) {
            return false;
        }
        if (other.attachObject() == null ^ this.attachObject() == null) {
            return false;
        }
        if (other.attachObject() != null && !other.attachObject().equals(this.attachObject())) {
            return false;
        }
        if (other.detachObject() == null ^ this.detachObject() == null) {
            return false;
        }
        if (other.detachObject() != null && !other.detachObject().equals(this.detachObject())) {
            return false;
        }
        if (other.updateObjectAttributes() == null ^ this.updateObjectAttributes() == null) {
            return false;
        }
        if (other.updateObjectAttributes() != null && !other.updateObjectAttributes().equals(this.updateObjectAttributes())) {
            return false;
        }
        if (other.deleteObject() == null ^ this.deleteObject() == null) {
            return false;
        }
        if (other.deleteObject() != null && !other.deleteObject().equals(this.deleteObject())) {
            return false;
        }
        if (other.addFacetToObject() == null ^ this.addFacetToObject() == null) {
            return false;
        }
        if (other.addFacetToObject() != null && !other.addFacetToObject().equals(this.addFacetToObject())) {
            return false;
        }
        if (other.removeFacetFromObject() == null ^ this.removeFacetFromObject() == null) {
            return false;
        }
        return other.removeFacetFromObject() == null || other.removeFacetFromObject().equals(this.removeFacetFromObject());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.createObject() != null) {
            sb.append("CreateObject: ").append(this.createObject()).append(",");
        }
        if (this.attachObject() != null) {
            sb.append("AttachObject: ").append(this.attachObject()).append(",");
        }
        if (this.detachObject() != null) {
            sb.append("DetachObject: ").append(this.detachObject()).append(",");
        }
        if (this.updateObjectAttributes() != null) {
            sb.append("UpdateObjectAttributes: ").append(this.updateObjectAttributes()).append(",");
        }
        if (this.deleteObject() != null) {
            sb.append("DeleteObject: ").append(this.deleteObject()).append(",");
        }
        if (this.addFacetToObject() != null) {
            sb.append("AddFacetToObject: ").append(this.addFacetToObject()).append(",");
        }
        if (this.removeFacetFromObject() != null) {
            sb.append("RemoveFacetFromObject: ").append(this.removeFacetFromObject()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchWriteOperationResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private BatchCreateObjectResponse createObject;
        private BatchAttachObjectResponse attachObject;
        private BatchDetachObjectResponse detachObject;
        private BatchUpdateObjectAttributesResponse updateObjectAttributes;
        private BatchDeleteObjectResponse deleteObject;
        private BatchAddFacetToObjectResponse addFacetToObject;
        private BatchRemoveFacetFromObjectResponse removeFacetFromObject;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteOperationResponse model) {
            this.setCreateObject(model.createObject);
            this.setAttachObject(model.attachObject);
            this.setDetachObject(model.detachObject);
            this.setUpdateObjectAttributes(model.updateObjectAttributes);
            this.setDeleteObject(model.deleteObject);
            this.setAddFacetToObject(model.addFacetToObject);
            this.setRemoveFacetFromObject(model.removeFacetFromObject);
        }

        public final BatchCreateObjectResponse getCreateObject() {
            return this.createObject;
        }

        @Override
        public final Builder createObject(BatchCreateObjectResponse createObject) {
            this.createObject = createObject;
            return this;
        }

        public final void setCreateObject(BatchCreateObjectResponse createObject) {
            this.createObject = createObject;
        }

        public final BatchAttachObjectResponse getAttachObject() {
            return this.attachObject;
        }

        @Override
        public final Builder attachObject(BatchAttachObjectResponse attachObject) {
            this.attachObject = attachObject;
            return this;
        }

        public final void setAttachObject(BatchAttachObjectResponse attachObject) {
            this.attachObject = attachObject;
        }

        public final BatchDetachObjectResponse getDetachObject() {
            return this.detachObject;
        }

        @Override
        public final Builder detachObject(BatchDetachObjectResponse detachObject) {
            this.detachObject = detachObject;
            return this;
        }

        public final void setDetachObject(BatchDetachObjectResponse detachObject) {
            this.detachObject = detachObject;
        }

        public final BatchUpdateObjectAttributesResponse getUpdateObjectAttributes() {
            return this.updateObjectAttributes;
        }

        @Override
        public final Builder updateObjectAttributes(BatchUpdateObjectAttributesResponse updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes;
            return this;
        }

        public final void setUpdateObjectAttributes(BatchUpdateObjectAttributesResponse updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes;
        }

        public final BatchDeleteObjectResponse getDeleteObject() {
            return this.deleteObject;
        }

        @Override
        public final Builder deleteObject(BatchDeleteObjectResponse deleteObject) {
            this.deleteObject = deleteObject;
            return this;
        }

        public final void setDeleteObject(BatchDeleteObjectResponse deleteObject) {
            this.deleteObject = deleteObject;
        }

        public final BatchAddFacetToObjectResponse getAddFacetToObject() {
            return this.addFacetToObject;
        }

        @Override
        public final Builder addFacetToObject(BatchAddFacetToObjectResponse addFacetToObject) {
            this.addFacetToObject = addFacetToObject;
            return this;
        }

        public final void setAddFacetToObject(BatchAddFacetToObjectResponse addFacetToObject) {
            this.addFacetToObject = addFacetToObject;
        }

        public final BatchRemoveFacetFromObjectResponse getRemoveFacetFromObject() {
            return this.removeFacetFromObject;
        }

        @Override
        public final Builder removeFacetFromObject(BatchRemoveFacetFromObjectResponse removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject;
            return this;
        }

        public final void setRemoveFacetFromObject(BatchRemoveFacetFromObjectResponse removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject;
        }

        public BatchWriteOperationResponse build() {
            return new BatchWriteOperationResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchWriteOperationResponse> {
        public Builder createObject(BatchCreateObjectResponse var1);

        public Builder attachObject(BatchAttachObjectResponse var1);

        public Builder detachObject(BatchDetachObjectResponse var1);

        public Builder updateObjectAttributes(BatchUpdateObjectAttributesResponse var1);

        public Builder deleteObject(BatchDeleteObjectResponse var1);

        public Builder addFacetToObject(BatchAddFacetToObjectResponse var1);

        public Builder removeFacetFromObject(BatchRemoveFacetFromObjectResponse var1);
    }
}

