/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachObject;

@SdkInternalApi
public class BatchAttachObjectMarshaller {
    private static final MarshallingInfo<StructuredPojo> PARENTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentReference").build();
    private static final MarshallingInfo<StructuredPojo> CHILDREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChildReference").build();
    private static final MarshallingInfo<String> LINKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LinkName").build();
    private static final BatchAttachObjectMarshaller instance = new BatchAttachObjectMarshaller();

    public static BatchAttachObjectMarshaller getInstance() {
        return instance;
    }

    public void marshall(BatchAttachObject batchAttachObject, ProtocolMarshaller protocolMarshaller) {
        if (batchAttachObject == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)batchAttachObject.parentReference(), PARENTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)batchAttachObject.childReference(), CHILDREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)batchAttachObject.linkName(), LINKNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

