/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinitionListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.TypedLinkFacetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TypedLinkFacet
implements StructuredPojo,
ToCopyableBuilder<Builder, TypedLinkFacet> {
    private final String name;
    private final List<TypedLinkAttributeDefinition> attributes;
    private final List<String> identityAttributeOrder;

    private TypedLinkFacet(BuilderImpl builder) {
        this.name = builder.name;
        this.attributes = builder.attributes;
        this.identityAttributeOrder = builder.identityAttributeOrder;
    }

    public String name() {
        return this.name;
    }

    public List<TypedLinkAttributeDefinition> attributes() {
        return this.attributes;
    }

    public List<String> identityAttributeOrder() {
        return this.identityAttributeOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.identityAttributeOrder() == null ? 0 : this.identityAttributeOrder().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkFacet)) {
            return false;
        }
        TypedLinkFacet other = (TypedLinkFacet)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.identityAttributeOrder() == null ^ this.identityAttributeOrder() == null) {
            return false;
        }
        return other.identityAttributeOrder() == null || other.identityAttributeOrder().equals(this.identityAttributeOrder());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.identityAttributeOrder() != null) {
            sb.append("IdentityAttributeOrder: ").append(this.identityAttributeOrder()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedLinkFacetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private List<TypedLinkAttributeDefinition> attributes;
        private List<String> identityAttributeOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkFacet model) {
            this.setName(model.name);
            this.setAttributes(model.attributes);
            this.setIdentityAttributeOrder(model.identityAttributeOrder);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<TypedLinkAttributeDefinition> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<TypedLinkAttributeDefinition> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TypedLinkAttributeDefinition ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<TypedLinkAttributeDefinition> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copy(attributes);
        }

        @SafeVarargs
        public final void setAttributes(TypedLinkAttributeDefinition ... attributes) {
            this.attributes(Arrays.asList(attributes));
        }

        public final Collection<String> getIdentityAttributeOrder() {
            return this.identityAttributeOrder;
        }

        @Override
        public final Builder identityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeOrder(String ... identityAttributeOrder) {
            this.identityAttributeOrder(Arrays.asList(identityAttributeOrder));
            return this;
        }

        public final void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
        }

        @SafeVarargs
        public final void setIdentityAttributeOrder(String ... identityAttributeOrder) {
            this.identityAttributeOrder(Arrays.asList(identityAttributeOrder));
        }

        public TypedLinkFacet build() {
            return new TypedLinkFacet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TypedLinkFacet> {
        public Builder name(String var1);

        public Builder attributes(Collection<TypedLinkAttributeDefinition> var1);

        public Builder attributes(TypedLinkAttributeDefinition ... var1);

        public Builder identityAttributeOrder(Collection<String> var1);

        public Builder identityAttributeOrder(String ... var1);
    }
}

