/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.ArnsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAppliedSchemaArnsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAppliedSchemaArnsResponse> {
    private final List<String> schemaArns;
    private final String nextToken;

    private ListAppliedSchemaArnsResponse(BuilderImpl builder) {
        this.schemaArns = builder.schemaArns;
        this.nextToken = builder.nextToken;
    }

    public List<String> schemaArns() {
        return this.schemaArns;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.schemaArns() == null ? 0 : this.schemaArns().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppliedSchemaArnsResponse)) {
            return false;
        }
        ListAppliedSchemaArnsResponse other = (ListAppliedSchemaArnsResponse)((Object)obj);
        if (other.schemaArns() == null ^ this.schemaArns() == null) {
            return false;
        }
        if (other.schemaArns() != null && !other.schemaArns().equals(this.schemaArns())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.schemaArns() != null) {
            sb.append("SchemaArns: ").append(this.schemaArns()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> schemaArns;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppliedSchemaArnsResponse model) {
            this.setSchemaArns(model.schemaArns);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getSchemaArns() {
            return this.schemaArns;
        }

        @Override
        public final Builder schemaArns(Collection<String> schemaArns) {
            this.schemaArns = ArnsCopier.copy(schemaArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaArns(String ... schemaArns) {
            this.schemaArns(Arrays.asList(schemaArns));
            return this;
        }

        public final void setSchemaArns(Collection<String> schemaArns) {
            this.schemaArns = ArnsCopier.copy(schemaArns);
        }

        @SafeVarargs
        public final void setSchemaArns(String ... schemaArns) {
            this.schemaArns(Arrays.asList(schemaArns));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListAppliedSchemaArnsResponse build() {
            return new ListAppliedSchemaArnsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAppliedSchemaArnsResponse> {
        public Builder schemaArns(Collection<String> var1);

        public Builder schemaArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

