/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.IndexAttachmentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IndexAttachment
implements StructuredPojo,
ToCopyableBuilder<Builder, IndexAttachment> {
    private final List<AttributeKeyAndValue> indexedAttributes;
    private final String objectIdentifier;

    private IndexAttachment(BuilderImpl builder) {
        this.indexedAttributes = builder.indexedAttributes;
        this.objectIdentifier = builder.objectIdentifier;
    }

    public List<AttributeKeyAndValue> indexedAttributes() {
        return this.indexedAttributes;
    }

    public String objectIdentifier() {
        return this.objectIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.indexedAttributes() == null ? 0 : this.indexedAttributes().hashCode());
        hashCode = 31 * hashCode + (this.objectIdentifier() == null ? 0 : this.objectIdentifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexAttachment)) {
            return false;
        }
        IndexAttachment other = (IndexAttachment)obj;
        if (other.indexedAttributes() == null ^ this.indexedAttributes() == null) {
            return false;
        }
        if (other.indexedAttributes() != null && !other.indexedAttributes().equals(this.indexedAttributes())) {
            return false;
        }
        if (other.objectIdentifier() == null ^ this.objectIdentifier() == null) {
            return false;
        }
        return other.objectIdentifier() == null || other.objectIdentifier().equals(this.objectIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.indexedAttributes() != null) {
            sb.append("IndexedAttributes: ").append(this.indexedAttributes()).append(",");
        }
        if (this.objectIdentifier() != null) {
            sb.append("ObjectIdentifier: ").append(this.objectIdentifier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IndexAttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AttributeKeyAndValue> indexedAttributes;
        private String objectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexAttachment model) {
            this.setIndexedAttributes(model.indexedAttributes);
            this.setObjectIdentifier(model.objectIdentifier);
        }

        public final Collection<AttributeKeyAndValue> getIndexedAttributes() {
            return this.indexedAttributes;
        }

        @Override
        public final Builder indexedAttributes(Collection<AttributeKeyAndValue> indexedAttributes) {
            this.indexedAttributes = AttributeKeyAndValueListCopier.copy(indexedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexedAttributes(AttributeKeyAndValue ... indexedAttributes) {
            this.indexedAttributes(Arrays.asList(indexedAttributes));
            return this;
        }

        public final void setIndexedAttributes(Collection<AttributeKeyAndValue> indexedAttributes) {
            this.indexedAttributes = AttributeKeyAndValueListCopier.copy(indexedAttributes);
        }

        @SafeVarargs
        public final void setIndexedAttributes(AttributeKeyAndValue ... indexedAttributes) {
            this.indexedAttributes(Arrays.asList(indexedAttributes));
        }

        public final String getObjectIdentifier() {
            return this.objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        public IndexAttachment build() {
            return new IndexAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IndexAttachment> {
        public Builder indexedAttributes(Collection<AttributeKeyAndValue> var1);

        public Builder indexedAttributes(AttributeKeyAndValue ... var1);

        public Builder objectIdentifier(String var1);
    }
}

