/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationResponseListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchReadResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchReadResponse> {
    private final List<BatchReadOperationResponse> responses;

    private BatchReadResponse(BuilderImpl builder) {
        this.responses = builder.responses;
    }

    public List<BatchReadOperationResponse> responses() {
        return this.responses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.responses() == null ? 0 : this.responses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadResponse)) {
            return false;
        }
        BatchReadResponse other = (BatchReadResponse)((Object)obj);
        if (other.responses() == null ^ this.responses() == null) {
            return false;
        }
        return other.responses() == null || other.responses().equals(this.responses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.responses() != null) {
            sb.append("Responses: ").append(this.responses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<BatchReadOperationResponse> responses;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadResponse model) {
            this.setResponses(model.responses);
        }

        public final Collection<BatchReadOperationResponse> getResponses() {
            return this.responses;
        }

        @Override
        public final Builder responses(Collection<BatchReadOperationResponse> responses) {
            this.responses = BatchReadOperationResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(BatchReadOperationResponse ... responses) {
            this.responses(Arrays.asList(responses));
            return this;
        }

        public final void setResponses(Collection<BatchReadOperationResponse> responses) {
            this.responses = BatchReadOperationResponseListCopier.copy(responses);
        }

        @SafeVarargs
        public final void setResponses(BatchReadOperationResponse ... responses) {
            this.responses(Arrays.asList(responses));
        }

        public BatchReadResponse build() {
            return new BatchReadResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchReadResponse> {
        public Builder responses(Collection<BatchReadOperationResponse> var1);

        public Builder responses(BatchReadOperationResponse ... var1);
    }
}

