/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.ObjectType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Facet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Facet> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Facet.getter(Facet::name)).setter(Facet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Facet.getter(Facet::objectTypeAsString)).setter(Facet.setter(Builder::objectType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OBJECT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String objectType;

    private Facet(BuilderImpl builder) {
        this.name = builder.name;
        this.objectType = builder.objectType;
    }

    public String name() {
        return this.name;
    }

    public ObjectType objectType() {
        return ObjectType.fromValue(this.objectType);
    }

    public String objectTypeAsString() {
        return this.objectType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Facet)) {
            return false;
        }
        Facet other = (Facet)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.objectTypeAsString(), other.objectTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Facet").add("Name", (Object)this.name()).add("ObjectType", (Object)this.objectTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ObjectType": {
                return Optional.ofNullable(clazz.cast(this.objectTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Facet, T> g) {
        return obj -> g.apply((Facet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String objectType;

        private BuilderImpl() {
        }

        private BuilderImpl(Facet model) {
            this.name(model.name);
            this.objectType(model.objectType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getObjectType() {
            return this.objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectType objectType) {
            this.objectType(objectType.toString());
            return this;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public Facet build() {
            return new Facet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Facet> {
        public Builder name(String var1);

        public Builder objectType(String var1);

        public Builder objectType(ObjectType var1);
    }
}

