/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TypedLinkFacetMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<List> IDENTITYATTRIBUTEORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityAttributeOrder").isBinary(false).build();
    private static final TypedLinkFacetMarshaller INSTANCE = new TypedLinkFacetMarshaller();

    private TypedLinkFacetMarshaller() {
    }

    public static TypedLinkFacetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TypedLinkFacet typedLinkFacet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)typedLinkFacet, (String)"typedLinkFacet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)typedLinkFacet.name(), NAME_BINDING);
            protocolMarshaller.marshall(typedLinkFacet.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall(typedLinkFacet.identityAttributeOrder(), IDENTITYATTRIBUTEORDER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

