/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetObjectAttributesRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").isBinary(false).build();
    private static final MarshallingInfo<String> CONSISTENCYLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-consistency-level").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCHEMAFACET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaFacet").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeNames").isBinary(false).build();
    private static final GetObjectAttributesRequestModelMarshaller INSTANCE = new GetObjectAttributesRequestModelMarshaller();

    private GetObjectAttributesRequestModelMarshaller() {
    }

    public static GetObjectAttributesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetObjectAttributesRequest getObjectAttributesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getObjectAttributesRequest), (String)"getObjectAttributesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getObjectAttributesRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)getObjectAttributesRequest.objectReference(), OBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)getObjectAttributesRequest.consistencyLevelAsString(), CONSISTENCYLEVEL_BINDING);
            protocolMarshaller.marshall((Object)getObjectAttributesRequest.schemaFacet(), SCHEMAFACET_BINDING);
            protocolMarshaller.marshall(getObjectAttributesRequest.attributeNames(), ATTRIBUTENAMES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

