/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetLinkAttributesRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TYPEDLINKSPECIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypedLinkSpecifier").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeNames").isBinary(false).build();
    private static final MarshallingInfo<String> CONSISTENCYLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsistencyLevel").isBinary(false).build();
    private static final GetLinkAttributesRequestModelMarshaller INSTANCE = new GetLinkAttributesRequestModelMarshaller();

    private GetLinkAttributesRequestModelMarshaller() {
    }

    public static GetLinkAttributesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetLinkAttributesRequest getLinkAttributesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getLinkAttributesRequest), (String)"getLinkAttributesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getLinkAttributesRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)getLinkAttributesRequest.typedLinkSpecifier(), TYPEDLINKSPECIFIER_BINDING);
            protocolMarshaller.marshall(getLinkAttributesRequest.attributeNames(), ATTRIBUTENAMES_BINDING);
            protocolMarshaller.marshall((Object)getLinkAttributesRequest.consistencyLevelAsString(), CONSISTENCYLEVEL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

