/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.CreateFacetRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateFacetRequestModelMarshaller {
    private static final MarshallingInfo<String> SCHEMAARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<String> OBJECTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectType").isBinary(false).build();
    private static final CreateFacetRequestModelMarshaller INSTANCE = new CreateFacetRequestModelMarshaller();

    private CreateFacetRequestModelMarshaller() {
    }

    public static CreateFacetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateFacetRequest createFacetRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createFacetRequest), (String)"createFacetRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createFacetRequest.schemaArn(), SCHEMAARN_BINDING);
            protocolMarshaller.marshall((Object)createFacetRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(createFacetRequest.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)createFacetRequest.objectTypeAsString(), OBJECTTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

