/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation;
import software.amazon.awssdk.services.clouddirectory.transform.BatchGetLinkAttributesUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchGetObjectAttributesUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchGetObjectInformationUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListAttachedIndicesUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListIncomingTypedLinksUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListIndexUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListObjectAttributesUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListObjectChildrenUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListObjectParentPathsUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListObjectPoliciesUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListOutgoingTypedLinksUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListPolicyAttachmentsUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchLookupPolicyUnmarshaller;

public class BatchReadOperationUnmarshaller
implements Unmarshaller<BatchReadOperation, JsonUnmarshallerContext> {
    private static final BatchReadOperationUnmarshaller INSTANCE = new BatchReadOperationUnmarshaller();

    public BatchReadOperation unmarshall(JsonUnmarshallerContext context) throws Exception {
        BatchReadOperation.Builder batchReadOperationBuilder = BatchReadOperation.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ListObjectAttributes", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.listObjectAttributes(BatchListObjectAttributesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ListObjectChildren", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.listObjectChildren(BatchListObjectChildrenUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ListAttachedIndices", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.listAttachedIndices(BatchListAttachedIndicesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ListObjectParentPaths", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.listObjectParentPaths(BatchListObjectParentPathsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("GetObjectInformation", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.getObjectInformation(BatchGetObjectInformationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("GetObjectAttributes", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.getObjectAttributes(BatchGetObjectAttributesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ListObjectPolicies", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.listObjectPolicies(BatchListObjectPoliciesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ListPolicyAttachments", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.listPolicyAttachments(BatchListPolicyAttachmentsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LookupPolicy", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.lookupPolicy(BatchLookupPolicyUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ListIndex", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.listIndex(BatchListIndexUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ListOutgoingTypedLinks", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.listOutgoingTypedLinks(BatchListOutgoingTypedLinksUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ListIncomingTypedLinks", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.listIncomingTypedLinks(BatchListIncomingTypedLinksUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("GetLinkAttributes", targetDepth)) {
                    context.nextToken();
                    batchReadOperationBuilder.getLinkAttributes(BatchGetLinkAttributesUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BatchReadOperation)batchReadOperationBuilder.build();
    }

    public static BatchReadOperationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

