/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributes;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchGetObjectAttributesMarshaller {
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCHEMAFACET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaFacet").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeNames").isBinary(false).build();
    private static final BatchGetObjectAttributesMarshaller INSTANCE = new BatchGetObjectAttributesMarshaller();

    private BatchGetObjectAttributesMarshaller() {
    }

    public static BatchGetObjectAttributesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchGetObjectAttributes batchGetObjectAttributes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchGetObjectAttributes, (String)"batchGetObjectAttributes");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchGetObjectAttributes.objectReference(), OBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)batchGetObjectAttributes.schemaFacet(), SCHEMAFACET_BINDING);
            protocolMarshaller.marshall(batchGetObjectAttributes.attributeNames(), ATTRIBUTENAMES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

