/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.LinkAttributeUpdate;
import software.amazon.awssdk.services.clouddirectory.model.LinkAttributeUpdateListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLinkAttributesRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, UpdateLinkAttributesRequest> {
    private final String directoryArn;
    private final TypedLinkSpecifier typedLinkSpecifier;
    private final List<LinkAttributeUpdate> attributeUpdates;

    private UpdateLinkAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.typedLinkSpecifier = builder.typedLinkSpecifier;
        this.attributeUpdates = builder.attributeUpdates;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public TypedLinkSpecifier typedLinkSpecifier() {
        return this.typedLinkSpecifier;
    }

    public List<LinkAttributeUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typedLinkSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeUpdates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLinkAttributesRequest)) {
            return false;
        }
        UpdateLinkAttributesRequest other = (UpdateLinkAttributesRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.typedLinkSpecifier(), other.typedLinkSpecifier()) && Objects.equals(this.attributeUpdates(), other.attributeUpdates());
    }

    public String toString() {
        return ToString.builder((String)"UpdateLinkAttributesRequest").add("DirectoryArn", (Object)this.directoryArn()).add("TypedLinkSpecifier", (Object)this.typedLinkSpecifier()).add("AttributeUpdates", this.attributeUpdates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "TypedLinkSpecifier": {
                return Optional.ofNullable(clazz.cast(this.typedLinkSpecifier()));
            }
            case "AttributeUpdates": {
                return Optional.ofNullable(clazz.cast(this.attributeUpdates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private TypedLinkSpecifier typedLinkSpecifier;
        private List<LinkAttributeUpdate> attributeUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLinkAttributesRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.typedLinkSpecifier(model.typedLinkSpecifier);
            this.attributeUpdates(model.attributeUpdates);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final TypedLinkSpecifier.Builder getTypedLinkSpecifier() {
            return this.typedLinkSpecifier != null ? this.typedLinkSpecifier.toBuilder() : null;
        }

        @Override
        public final Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier;
            return this;
        }

        public final void setTypedLinkSpecifier(TypedLinkSpecifier.BuilderImpl typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier != null ? typedLinkSpecifier.build() : null;
        }

        public final Collection<LinkAttributeUpdate.Builder> getAttributeUpdates() {
            return this.attributeUpdates != null ? (Collection)this.attributeUpdates.stream().map(LinkAttributeUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeUpdates(Collection<LinkAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = LinkAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(LinkAttributeUpdate ... attributeUpdates) {
            this.attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(Consumer<LinkAttributeUpdate.Builder> ... attributeUpdates) {
            this.attributeUpdates(Stream.of(attributeUpdates).map(c -> (LinkAttributeUpdate)((LinkAttributeUpdate.Builder)LinkAttributeUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeUpdates(Collection<LinkAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = LinkAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLinkAttributesRequest build() {
            return new UpdateLinkAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, UpdateLinkAttributesRequest> {
        public Builder directoryArn(String var1);

        public Builder typedLinkSpecifier(TypedLinkSpecifier var1);

        default public Builder typedLinkSpecifier(Consumer<TypedLinkSpecifier.Builder> typedLinkSpecifier) {
            return this.typedLinkSpecifier((TypedLinkSpecifier)((TypedLinkSpecifier.Builder)TypedLinkSpecifier.builder().applyMutation(typedLinkSpecifier)).build());
        }

        public Builder attributeUpdates(Collection<LinkAttributeUpdate> var1);

        public Builder attributeUpdates(LinkAttributeUpdate ... var1);

        public Builder attributeUpdates(Consumer<LinkAttributeUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

