/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLinkAttributesResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, GetLinkAttributesResponse> {
    private final List<AttributeKeyAndValue> attributes;

    private GetLinkAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    public List<AttributeKeyAndValue> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinkAttributesResponse)) {
            return false;
        }
        GetLinkAttributesResponse other = (GetLinkAttributesResponse)((Object)obj);
        return Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"GetLinkAttributesResponse").add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<AttributeKeyAndValue> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinkAttributesResponse model) {
            super(model);
            this.attributes(model.attributes);
        }

        public final Collection<AttributeKeyAndValue.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(AttributeKeyAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<AttributeKeyAndValue> attributes) {
            this.attributes = AttributeKeyAndValueListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeKeyAndValue ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AttributeKeyAndValue.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (AttributeKeyAndValue)((AttributeKeyAndValue.Builder)AttributeKeyAndValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<AttributeKeyAndValue.BuilderImpl> attributes) {
            this.attributes = AttributeKeyAndValueListCopier.copyFromBuilder(attributes);
        }

        @Override
        public GetLinkAttributesResponse build() {
            return new GetLinkAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, GetLinkAttributesResponse> {
        public Builder attributes(Collection<AttributeKeyAndValue> var1);

        public Builder attributes(AttributeKeyAndValue ... var1);

        public Builder attributes(Consumer<AttributeKeyAndValue.Builder> ... var1);
    }
}

