/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchGetLinkAttributes;
import software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributes;
import software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformation;
import software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndices;
import software.amazon.awssdk.services.clouddirectory.model.BatchListIncomingTypedLinks;
import software.amazon.awssdk.services.clouddirectory.model.BatchListIndex;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectAttributes;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectChildren;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentPaths;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectPolicies;
import software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinks;
import software.amazon.awssdk.services.clouddirectory.model.BatchListPolicyAttachments;
import software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicy;
import software.amazon.awssdk.services.clouddirectory.transform.BatchReadOperationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchReadOperation
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchReadOperation> {
    private final BatchListObjectAttributes listObjectAttributes;
    private final BatchListObjectChildren listObjectChildren;
    private final BatchListAttachedIndices listAttachedIndices;
    private final BatchListObjectParentPaths listObjectParentPaths;
    private final BatchGetObjectInformation getObjectInformation;
    private final BatchGetObjectAttributes getObjectAttributes;
    private final BatchListObjectPolicies listObjectPolicies;
    private final BatchListPolicyAttachments listPolicyAttachments;
    private final BatchLookupPolicy lookupPolicy;
    private final BatchListIndex listIndex;
    private final BatchListOutgoingTypedLinks listOutgoingTypedLinks;
    private final BatchListIncomingTypedLinks listIncomingTypedLinks;
    private final BatchGetLinkAttributes getLinkAttributes;

    private BatchReadOperation(BuilderImpl builder) {
        this.listObjectAttributes = builder.listObjectAttributes;
        this.listObjectChildren = builder.listObjectChildren;
        this.listAttachedIndices = builder.listAttachedIndices;
        this.listObjectParentPaths = builder.listObjectParentPaths;
        this.getObjectInformation = builder.getObjectInformation;
        this.getObjectAttributes = builder.getObjectAttributes;
        this.listObjectPolicies = builder.listObjectPolicies;
        this.listPolicyAttachments = builder.listPolicyAttachments;
        this.lookupPolicy = builder.lookupPolicy;
        this.listIndex = builder.listIndex;
        this.listOutgoingTypedLinks = builder.listOutgoingTypedLinks;
        this.listIncomingTypedLinks = builder.listIncomingTypedLinks;
        this.getLinkAttributes = builder.getLinkAttributes;
    }

    public BatchListObjectAttributes listObjectAttributes() {
        return this.listObjectAttributes;
    }

    public BatchListObjectChildren listObjectChildren() {
        return this.listObjectChildren;
    }

    public BatchListAttachedIndices listAttachedIndices() {
        return this.listAttachedIndices;
    }

    public BatchListObjectParentPaths listObjectParentPaths() {
        return this.listObjectParentPaths;
    }

    public BatchGetObjectInformation getObjectInformation() {
        return this.getObjectInformation;
    }

    public BatchGetObjectAttributes getObjectAttributes() {
        return this.getObjectAttributes;
    }

    public BatchListObjectPolicies listObjectPolicies() {
        return this.listObjectPolicies;
    }

    public BatchListPolicyAttachments listPolicyAttachments() {
        return this.listPolicyAttachments;
    }

    public BatchLookupPolicy lookupPolicy() {
        return this.lookupPolicy;
    }

    public BatchListIndex listIndex() {
        return this.listIndex;
    }

    public BatchListOutgoingTypedLinks listOutgoingTypedLinks() {
        return this.listOutgoingTypedLinks;
    }

    public BatchListIncomingTypedLinks listIncomingTypedLinks() {
        return this.listIncomingTypedLinks;
    }

    public BatchGetLinkAttributes getLinkAttributes() {
        return this.getLinkAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.listObjectChildren());
        hashCode = 31 * hashCode + Objects.hashCode(this.listAttachedIndices());
        hashCode = 31 * hashCode + Objects.hashCode(this.listObjectParentPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.getObjectInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.getObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.listObjectPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.listPolicyAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookupPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.listIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.listOutgoingTypedLinks());
        hashCode = 31 * hashCode + Objects.hashCode(this.listIncomingTypedLinks());
        hashCode = 31 * hashCode + Objects.hashCode(this.getLinkAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadOperation)) {
            return false;
        }
        BatchReadOperation other = (BatchReadOperation)obj;
        return Objects.equals(this.listObjectAttributes(), other.listObjectAttributes()) && Objects.equals(this.listObjectChildren(), other.listObjectChildren()) && Objects.equals(this.listAttachedIndices(), other.listAttachedIndices()) && Objects.equals(this.listObjectParentPaths(), other.listObjectParentPaths()) && Objects.equals(this.getObjectInformation(), other.getObjectInformation()) && Objects.equals(this.getObjectAttributes(), other.getObjectAttributes()) && Objects.equals(this.listObjectPolicies(), other.listObjectPolicies()) && Objects.equals(this.listPolicyAttachments(), other.listPolicyAttachments()) && Objects.equals(this.lookupPolicy(), other.lookupPolicy()) && Objects.equals(this.listIndex(), other.listIndex()) && Objects.equals(this.listOutgoingTypedLinks(), other.listOutgoingTypedLinks()) && Objects.equals(this.listIncomingTypedLinks(), other.listIncomingTypedLinks()) && Objects.equals(this.getLinkAttributes(), other.getLinkAttributes());
    }

    public String toString() {
        return ToString.builder((String)"BatchReadOperation").add("ListObjectAttributes", (Object)this.listObjectAttributes()).add("ListObjectChildren", (Object)this.listObjectChildren()).add("ListAttachedIndices", (Object)this.listAttachedIndices()).add("ListObjectParentPaths", (Object)this.listObjectParentPaths()).add("GetObjectInformation", (Object)this.getObjectInformation()).add("GetObjectAttributes", (Object)this.getObjectAttributes()).add("ListObjectPolicies", (Object)this.listObjectPolicies()).add("ListPolicyAttachments", (Object)this.listPolicyAttachments()).add("LookupPolicy", (Object)this.lookupPolicy()).add("ListIndex", (Object)this.listIndex()).add("ListOutgoingTypedLinks", (Object)this.listOutgoingTypedLinks()).add("ListIncomingTypedLinks", (Object)this.listIncomingTypedLinks()).add("GetLinkAttributes", (Object)this.getLinkAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListObjectAttributes": {
                return Optional.ofNullable(clazz.cast(this.listObjectAttributes()));
            }
            case "ListObjectChildren": {
                return Optional.ofNullable(clazz.cast(this.listObjectChildren()));
            }
            case "ListAttachedIndices": {
                return Optional.ofNullable(clazz.cast(this.listAttachedIndices()));
            }
            case "ListObjectParentPaths": {
                return Optional.ofNullable(clazz.cast(this.listObjectParentPaths()));
            }
            case "GetObjectInformation": {
                return Optional.ofNullable(clazz.cast(this.getObjectInformation()));
            }
            case "GetObjectAttributes": {
                return Optional.ofNullable(clazz.cast(this.getObjectAttributes()));
            }
            case "ListObjectPolicies": {
                return Optional.ofNullable(clazz.cast(this.listObjectPolicies()));
            }
            case "ListPolicyAttachments": {
                return Optional.ofNullable(clazz.cast(this.listPolicyAttachments()));
            }
            case "LookupPolicy": {
                return Optional.ofNullable(clazz.cast(this.lookupPolicy()));
            }
            case "ListIndex": {
                return Optional.ofNullable(clazz.cast(this.listIndex()));
            }
            case "ListOutgoingTypedLinks": {
                return Optional.ofNullable(clazz.cast(this.listOutgoingTypedLinks()));
            }
            case "ListIncomingTypedLinks": {
                return Optional.ofNullable(clazz.cast(this.listIncomingTypedLinks()));
            }
            case "GetLinkAttributes": {
                return Optional.ofNullable(clazz.cast(this.getLinkAttributes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchReadOperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BatchListObjectAttributes listObjectAttributes;
        private BatchListObjectChildren listObjectChildren;
        private BatchListAttachedIndices listAttachedIndices;
        private BatchListObjectParentPaths listObjectParentPaths;
        private BatchGetObjectInformation getObjectInformation;
        private BatchGetObjectAttributes getObjectAttributes;
        private BatchListObjectPolicies listObjectPolicies;
        private BatchListPolicyAttachments listPolicyAttachments;
        private BatchLookupPolicy lookupPolicy;
        private BatchListIndex listIndex;
        private BatchListOutgoingTypedLinks listOutgoingTypedLinks;
        private BatchListIncomingTypedLinks listIncomingTypedLinks;
        private BatchGetLinkAttributes getLinkAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadOperation model) {
            this.listObjectAttributes(model.listObjectAttributes);
            this.listObjectChildren(model.listObjectChildren);
            this.listAttachedIndices(model.listAttachedIndices);
            this.listObjectParentPaths(model.listObjectParentPaths);
            this.getObjectInformation(model.getObjectInformation);
            this.getObjectAttributes(model.getObjectAttributes);
            this.listObjectPolicies(model.listObjectPolicies);
            this.listPolicyAttachments(model.listPolicyAttachments);
            this.lookupPolicy(model.lookupPolicy);
            this.listIndex(model.listIndex);
            this.listOutgoingTypedLinks(model.listOutgoingTypedLinks);
            this.listIncomingTypedLinks(model.listIncomingTypedLinks);
            this.getLinkAttributes(model.getLinkAttributes);
        }

        public final BatchListObjectAttributes.Builder getListObjectAttributes() {
            return this.listObjectAttributes != null ? this.listObjectAttributes.toBuilder() : null;
        }

        @Override
        public final Builder listObjectAttributes(BatchListObjectAttributes listObjectAttributes) {
            this.listObjectAttributes = listObjectAttributes;
            return this;
        }

        public final void setListObjectAttributes(BatchListObjectAttributes.BuilderImpl listObjectAttributes) {
            this.listObjectAttributes = listObjectAttributes != null ? listObjectAttributes.build() : null;
        }

        public final BatchListObjectChildren.Builder getListObjectChildren() {
            return this.listObjectChildren != null ? this.listObjectChildren.toBuilder() : null;
        }

        @Override
        public final Builder listObjectChildren(BatchListObjectChildren listObjectChildren) {
            this.listObjectChildren = listObjectChildren;
            return this;
        }

        public final void setListObjectChildren(BatchListObjectChildren.BuilderImpl listObjectChildren) {
            this.listObjectChildren = listObjectChildren != null ? listObjectChildren.build() : null;
        }

        public final BatchListAttachedIndices.Builder getListAttachedIndices() {
            return this.listAttachedIndices != null ? this.listAttachedIndices.toBuilder() : null;
        }

        @Override
        public final Builder listAttachedIndices(BatchListAttachedIndices listAttachedIndices) {
            this.listAttachedIndices = listAttachedIndices;
            return this;
        }

        public final void setListAttachedIndices(BatchListAttachedIndices.BuilderImpl listAttachedIndices) {
            this.listAttachedIndices = listAttachedIndices != null ? listAttachedIndices.build() : null;
        }

        public final BatchListObjectParentPaths.Builder getListObjectParentPaths() {
            return this.listObjectParentPaths != null ? this.listObjectParentPaths.toBuilder() : null;
        }

        @Override
        public final Builder listObjectParentPaths(BatchListObjectParentPaths listObjectParentPaths) {
            this.listObjectParentPaths = listObjectParentPaths;
            return this;
        }

        public final void setListObjectParentPaths(BatchListObjectParentPaths.BuilderImpl listObjectParentPaths) {
            this.listObjectParentPaths = listObjectParentPaths != null ? listObjectParentPaths.build() : null;
        }

        public final BatchGetObjectInformation.Builder getGetObjectInformation() {
            return this.getObjectInformation != null ? this.getObjectInformation.toBuilder() : null;
        }

        @Override
        public final Builder getObjectInformation(BatchGetObjectInformation getObjectInformation) {
            this.getObjectInformation = getObjectInformation;
            return this;
        }

        public final void setGetObjectInformation(BatchGetObjectInformation.BuilderImpl getObjectInformation) {
            this.getObjectInformation = getObjectInformation != null ? getObjectInformation.build() : null;
        }

        public final BatchGetObjectAttributes.Builder getGetObjectAttributes() {
            return this.getObjectAttributes != null ? this.getObjectAttributes.toBuilder() : null;
        }

        @Override
        public final Builder getObjectAttributes(BatchGetObjectAttributes getObjectAttributes) {
            this.getObjectAttributes = getObjectAttributes;
            return this;
        }

        public final void setGetObjectAttributes(BatchGetObjectAttributes.BuilderImpl getObjectAttributes) {
            this.getObjectAttributes = getObjectAttributes != null ? getObjectAttributes.build() : null;
        }

        public final BatchListObjectPolicies.Builder getListObjectPolicies() {
            return this.listObjectPolicies != null ? this.listObjectPolicies.toBuilder() : null;
        }

        @Override
        public final Builder listObjectPolicies(BatchListObjectPolicies listObjectPolicies) {
            this.listObjectPolicies = listObjectPolicies;
            return this;
        }

        public final void setListObjectPolicies(BatchListObjectPolicies.BuilderImpl listObjectPolicies) {
            this.listObjectPolicies = listObjectPolicies != null ? listObjectPolicies.build() : null;
        }

        public final BatchListPolicyAttachments.Builder getListPolicyAttachments() {
            return this.listPolicyAttachments != null ? this.listPolicyAttachments.toBuilder() : null;
        }

        @Override
        public final Builder listPolicyAttachments(BatchListPolicyAttachments listPolicyAttachments) {
            this.listPolicyAttachments = listPolicyAttachments;
            return this;
        }

        public final void setListPolicyAttachments(BatchListPolicyAttachments.BuilderImpl listPolicyAttachments) {
            this.listPolicyAttachments = listPolicyAttachments != null ? listPolicyAttachments.build() : null;
        }

        public final BatchLookupPolicy.Builder getLookupPolicy() {
            return this.lookupPolicy != null ? this.lookupPolicy.toBuilder() : null;
        }

        @Override
        public final Builder lookupPolicy(BatchLookupPolicy lookupPolicy) {
            this.lookupPolicy = lookupPolicy;
            return this;
        }

        public final void setLookupPolicy(BatchLookupPolicy.BuilderImpl lookupPolicy) {
            this.lookupPolicy = lookupPolicy != null ? lookupPolicy.build() : null;
        }

        public final BatchListIndex.Builder getListIndex() {
            return this.listIndex != null ? this.listIndex.toBuilder() : null;
        }

        @Override
        public final Builder listIndex(BatchListIndex listIndex) {
            this.listIndex = listIndex;
            return this;
        }

        public final void setListIndex(BatchListIndex.BuilderImpl listIndex) {
            this.listIndex = listIndex != null ? listIndex.build() : null;
        }

        public final BatchListOutgoingTypedLinks.Builder getListOutgoingTypedLinks() {
            return this.listOutgoingTypedLinks != null ? this.listOutgoingTypedLinks.toBuilder() : null;
        }

        @Override
        public final Builder listOutgoingTypedLinks(BatchListOutgoingTypedLinks listOutgoingTypedLinks) {
            this.listOutgoingTypedLinks = listOutgoingTypedLinks;
            return this;
        }

        public final void setListOutgoingTypedLinks(BatchListOutgoingTypedLinks.BuilderImpl listOutgoingTypedLinks) {
            this.listOutgoingTypedLinks = listOutgoingTypedLinks != null ? listOutgoingTypedLinks.build() : null;
        }

        public final BatchListIncomingTypedLinks.Builder getListIncomingTypedLinks() {
            return this.listIncomingTypedLinks != null ? this.listIncomingTypedLinks.toBuilder() : null;
        }

        @Override
        public final Builder listIncomingTypedLinks(BatchListIncomingTypedLinks listIncomingTypedLinks) {
            this.listIncomingTypedLinks = listIncomingTypedLinks;
            return this;
        }

        public final void setListIncomingTypedLinks(BatchListIncomingTypedLinks.BuilderImpl listIncomingTypedLinks) {
            this.listIncomingTypedLinks = listIncomingTypedLinks != null ? listIncomingTypedLinks.build() : null;
        }

        public final BatchGetLinkAttributes.Builder getGetLinkAttributes() {
            return this.getLinkAttributes != null ? this.getLinkAttributes.toBuilder() : null;
        }

        @Override
        public final Builder getLinkAttributes(BatchGetLinkAttributes getLinkAttributes) {
            this.getLinkAttributes = getLinkAttributes;
            return this;
        }

        public final void setGetLinkAttributes(BatchGetLinkAttributes.BuilderImpl getLinkAttributes) {
            this.getLinkAttributes = getLinkAttributes != null ? getLinkAttributes.build() : null;
        }

        public BatchReadOperation build() {
            return new BatchReadOperation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchReadOperation> {
        public Builder listObjectAttributes(BatchListObjectAttributes var1);

        default public Builder listObjectAttributes(Consumer<BatchListObjectAttributes.Builder> listObjectAttributes) {
            return this.listObjectAttributes((BatchListObjectAttributes)((BatchListObjectAttributes.Builder)BatchListObjectAttributes.builder().applyMutation(listObjectAttributes)).build());
        }

        public Builder listObjectChildren(BatchListObjectChildren var1);

        default public Builder listObjectChildren(Consumer<BatchListObjectChildren.Builder> listObjectChildren) {
            return this.listObjectChildren((BatchListObjectChildren)((BatchListObjectChildren.Builder)BatchListObjectChildren.builder().applyMutation(listObjectChildren)).build());
        }

        public Builder listAttachedIndices(BatchListAttachedIndices var1);

        default public Builder listAttachedIndices(Consumer<BatchListAttachedIndices.Builder> listAttachedIndices) {
            return this.listAttachedIndices((BatchListAttachedIndices)((BatchListAttachedIndices.Builder)BatchListAttachedIndices.builder().applyMutation(listAttachedIndices)).build());
        }

        public Builder listObjectParentPaths(BatchListObjectParentPaths var1);

        default public Builder listObjectParentPaths(Consumer<BatchListObjectParentPaths.Builder> listObjectParentPaths) {
            return this.listObjectParentPaths((BatchListObjectParentPaths)((BatchListObjectParentPaths.Builder)BatchListObjectParentPaths.builder().applyMutation(listObjectParentPaths)).build());
        }

        public Builder getObjectInformation(BatchGetObjectInformation var1);

        default public Builder getObjectInformation(Consumer<BatchGetObjectInformation.Builder> getObjectInformation) {
            return this.getObjectInformation((BatchGetObjectInformation)((BatchGetObjectInformation.Builder)BatchGetObjectInformation.builder().applyMutation(getObjectInformation)).build());
        }

        public Builder getObjectAttributes(BatchGetObjectAttributes var1);

        default public Builder getObjectAttributes(Consumer<BatchGetObjectAttributes.Builder> getObjectAttributes) {
            return this.getObjectAttributes((BatchGetObjectAttributes)((BatchGetObjectAttributes.Builder)BatchGetObjectAttributes.builder().applyMutation(getObjectAttributes)).build());
        }

        public Builder listObjectPolicies(BatchListObjectPolicies var1);

        default public Builder listObjectPolicies(Consumer<BatchListObjectPolicies.Builder> listObjectPolicies) {
            return this.listObjectPolicies((BatchListObjectPolicies)((BatchListObjectPolicies.Builder)BatchListObjectPolicies.builder().applyMutation(listObjectPolicies)).build());
        }

        public Builder listPolicyAttachments(BatchListPolicyAttachments var1);

        default public Builder listPolicyAttachments(Consumer<BatchListPolicyAttachments.Builder> listPolicyAttachments) {
            return this.listPolicyAttachments((BatchListPolicyAttachments)((BatchListPolicyAttachments.Builder)BatchListPolicyAttachments.builder().applyMutation(listPolicyAttachments)).build());
        }

        public Builder lookupPolicy(BatchLookupPolicy var1);

        default public Builder lookupPolicy(Consumer<BatchLookupPolicy.Builder> lookupPolicy) {
            return this.lookupPolicy((BatchLookupPolicy)((BatchLookupPolicy.Builder)BatchLookupPolicy.builder().applyMutation(lookupPolicy)).build());
        }

        public Builder listIndex(BatchListIndex var1);

        default public Builder listIndex(Consumer<BatchListIndex.Builder> listIndex) {
            return this.listIndex((BatchListIndex)((BatchListIndex.Builder)BatchListIndex.builder().applyMutation(listIndex)).build());
        }

        public Builder listOutgoingTypedLinks(BatchListOutgoingTypedLinks var1);

        default public Builder listOutgoingTypedLinks(Consumer<BatchListOutgoingTypedLinks.Builder> listOutgoingTypedLinks) {
            return this.listOutgoingTypedLinks((BatchListOutgoingTypedLinks)((BatchListOutgoingTypedLinks.Builder)BatchListOutgoingTypedLinks.builder().applyMutation(listOutgoingTypedLinks)).build());
        }

        public Builder listIncomingTypedLinks(BatchListIncomingTypedLinks var1);

        default public Builder listIncomingTypedLinks(Consumer<BatchListIncomingTypedLinks.Builder> listIncomingTypedLinks) {
            return this.listIncomingTypedLinks((BatchListIncomingTypedLinks)((BatchListIncomingTypedLinks.Builder)BatchListIncomingTypedLinks.builder().applyMutation(listIncomingTypedLinks)).build());
        }

        public Builder getLinkAttributes(BatchGetLinkAttributes var1);

        default public Builder getLinkAttributes(Consumer<BatchGetLinkAttributes.Builder> getLinkAttributes) {
            return this.getLinkAttributes((BatchGetLinkAttributes)((BatchGetLinkAttributes.Builder)BatchGetLinkAttributes.builder().applyMutation(getLinkAttributes)).build());
        }
    }
}

