/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.services.clouddirectory.transform.BatchGetObjectAttributesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetObjectAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchGetObjectAttributes> {
    private final ObjectReference objectReference;
    private final SchemaFacet schemaFacet;
    private final List<String> attributeNames;

    private BatchGetObjectAttributes(BuilderImpl builder) {
        this.objectReference = builder.objectReference;
        this.schemaFacet = builder.schemaFacet;
        this.attributeNames = builder.attributeNames;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public SchemaFacet schemaFacet() {
        return this.schemaFacet;
    }

    public List<String> attributeNames() {
        return this.attributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaFacet());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetObjectAttributes)) {
            return false;
        }
        BatchGetObjectAttributes other = (BatchGetObjectAttributes)obj;
        return Objects.equals(this.objectReference(), other.objectReference()) && Objects.equals(this.schemaFacet(), other.schemaFacet()) && Objects.equals(this.attributeNames(), other.attributeNames());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetObjectAttributes").add("ObjectReference", (Object)this.objectReference()).add("SchemaFacet", (Object)this.schemaFacet()).add("AttributeNames", this.attributeNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
            case "SchemaFacet": {
                return Optional.ofNullable(clazz.cast(this.schemaFacet()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNames()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchGetObjectAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference objectReference;
        private SchemaFacet schemaFacet;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetObjectAttributes model) {
            this.objectReference(model.objectReference);
            this.schemaFacet(model.schemaFacet);
            this.attributeNames(model.attributeNames);
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final SchemaFacet.Builder getSchemaFacet() {
            return this.schemaFacet != null ? this.schemaFacet.toBuilder() : null;
        }

        @Override
        public final Builder schemaFacet(SchemaFacet schemaFacet) {
            this.schemaFacet = schemaFacet;
            return this;
        }

        public final void setSchemaFacet(SchemaFacet.BuilderImpl schemaFacet) {
            this.schemaFacet = schemaFacet != null ? schemaFacet.build() : null;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        public BatchGetObjectAttributes build() {
            return new BatchGetObjectAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetObjectAttributes> {
        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }

        public Builder schemaFacet(SchemaFacet var1);

        default public Builder schemaFacet(Consumer<SchemaFacet.Builder> schemaFacet) {
            return this.schemaFacet((SchemaFacet)((SchemaFacet.Builder)SchemaFacet.builder().applyMutation(schemaFacet)).build());
        }

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);
    }
}

