/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.services.clouddirectory.transform.BatchGetLinkAttributesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetLinkAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchGetLinkAttributes> {
    private final TypedLinkSpecifier typedLinkSpecifier;
    private final List<String> attributeNames;

    private BatchGetLinkAttributes(BuilderImpl builder) {
        this.typedLinkSpecifier = builder.typedLinkSpecifier;
        this.attributeNames = builder.attributeNames;
    }

    public TypedLinkSpecifier typedLinkSpecifier() {
        return this.typedLinkSpecifier;
    }

    public List<String> attributeNames() {
        return this.attributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typedLinkSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetLinkAttributes)) {
            return false;
        }
        BatchGetLinkAttributes other = (BatchGetLinkAttributes)obj;
        return Objects.equals(this.typedLinkSpecifier(), other.typedLinkSpecifier()) && Objects.equals(this.attributeNames(), other.attributeNames());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetLinkAttributes").add("TypedLinkSpecifier", (Object)this.typedLinkSpecifier()).add("AttributeNames", this.attributeNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypedLinkSpecifier": {
                return Optional.ofNullable(clazz.cast(this.typedLinkSpecifier()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNames()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchGetLinkAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private TypedLinkSpecifier typedLinkSpecifier;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetLinkAttributes model) {
            this.typedLinkSpecifier(model.typedLinkSpecifier);
            this.attributeNames(model.attributeNames);
        }

        public final TypedLinkSpecifier.Builder getTypedLinkSpecifier() {
            return this.typedLinkSpecifier != null ? this.typedLinkSpecifier.toBuilder() : null;
        }

        @Override
        public final Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier;
            return this;
        }

        public final void setTypedLinkSpecifier(TypedLinkSpecifier.BuilderImpl typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier != null ? typedLinkSpecifier.build() : null;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        public BatchGetLinkAttributes build() {
            return new BatchGetLinkAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetLinkAttributes> {
        public Builder typedLinkSpecifier(TypedLinkSpecifier var1);

        default public Builder typedLinkSpecifier(Consumer<TypedLinkSpecifier.Builder> typedLinkSpecifier) {
            return this.typedLinkSpecifier((TypedLinkSpecifier)((TypedLinkSpecifier.Builder)TypedLinkSpecifier.builder().applyMutation(typedLinkSpecifier)).build());
        }

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);
    }
}

