/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKey;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue;
import software.amazon.awssdk.services.clouddirectory.transform.AttributeKeyAndValueMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeKeyAndValue
implements StructuredPojo,
ToCopyableBuilder<Builder, AttributeKeyAndValue> {
    private final AttributeKey key;
    private final TypedAttributeValue value;

    private AttributeKeyAndValue(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    public AttributeKey key() {
        return this.key;
    }

    public TypedAttributeValue value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeKeyAndValue)) {
            return false;
        }
        AttributeKeyAndValue other = (AttributeKeyAndValue)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"AttributeKeyAndValue").add("Key", (Object)this.key()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeKeyAndValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AttributeKey key;
        private TypedAttributeValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeKeyAndValue model) {
            this.key(model.key);
            this.value(model.value);
        }

        public final AttributeKey.Builder getKey() {
            return this.key != null ? this.key.toBuilder() : null;
        }

        @Override
        public final Builder key(AttributeKey key) {
            this.key = key;
            return this;
        }

        public final void setKey(AttributeKey.BuilderImpl key) {
            this.key = key != null ? key.build() : null;
        }

        public final TypedAttributeValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        @Override
        public final Builder value(TypedAttributeValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(TypedAttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public AttributeKeyAndValue build() {
            return new AttributeKeyAndValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttributeKeyAndValue> {
        public Builder key(AttributeKey var1);

        default public Builder key(Consumer<AttributeKey.Builder> key) {
            return this.key((AttributeKey)((AttributeKey.Builder)AttributeKey.builder().applyMutation(key)).build());
        }

        public Builder value(TypedAttributeValue var1);

        default public Builder value(Consumer<TypedAttributeValue.Builder> value) {
            return this.value((TypedAttributeValue)((TypedAttributeValue.Builder)TypedAttributeValue.builder().applyMutation(value)).build());
        }
    }
}

