/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.IndexAttachment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IndexAttachmentMarshaller {
    private static final MarshallingInfo<List> INDEXEDATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexedAttributes").isBinary(false).build();
    private static final MarshallingInfo<String> OBJECTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectIdentifier").isBinary(false).build();
    private static final IndexAttachmentMarshaller INSTANCE = new IndexAttachmentMarshaller();

    private IndexAttachmentMarshaller() {
    }

    public static IndexAttachmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IndexAttachment indexAttachment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)indexAttachment, (String)"indexAttachment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(indexAttachment.indexedAttributes(), INDEXEDATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)indexAttachment.objectIdentifier(), OBJECTIDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

