/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.DetachObjectRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DetachObjectRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PARENTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentReference").isBinary(false).build();
    private static final MarshallingInfo<String> LINKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LinkName").isBinary(false).build();
    private static final DetachObjectRequestModelMarshaller INSTANCE = new DetachObjectRequestModelMarshaller();

    private DetachObjectRequestModelMarshaller() {
    }

    public static DetachObjectRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DetachObjectRequest detachObjectRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)detachObjectRequest), (String)"detachObjectRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)detachObjectRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)detachObjectRequest.parentReference(), PARENTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)detachObjectRequest.linkName(), LINKNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

