/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchWriteOperationMarshaller {
    private static final MarshallingInfo<StructuredPojo> CREATEOBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateObject").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ATTACHOBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttachObject").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DETACHOBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetachObject").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> UPDATEOBJECTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateObjectAttributes").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DELETEOBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeleteObject").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ADDFACETTOOBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddFacetToObject").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REMOVEFACETFROMOBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RemoveFacetFromObject").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ATTACHPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttachPolicy").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DETACHPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetachPolicy").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CREATEINDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateIndex").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ATTACHTOINDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttachToIndex").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DETACHFROMINDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetachFromIndex").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ATTACHTYPEDLINK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttachTypedLink").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DETACHTYPEDLINK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetachTypedLink").isBinary(false).build();
    private static final BatchWriteOperationMarshaller INSTANCE = new BatchWriteOperationMarshaller();

    private BatchWriteOperationMarshaller() {
    }

    public static BatchWriteOperationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchWriteOperation batchWriteOperation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchWriteOperation, (String)"batchWriteOperation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchWriteOperation.createObject(), CREATEOBJECT_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.attachObject(), ATTACHOBJECT_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.detachObject(), DETACHOBJECT_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.updateObjectAttributes(), UPDATEOBJECTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.deleteObject(), DELETEOBJECT_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.addFacetToObject(), ADDFACETTOOBJECT_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.removeFacetFromObject(), REMOVEFACETFROMOBJECT_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.attachPolicy(), ATTACHPOLICY_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.detachPolicy(), DETACHPOLICY_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.createIndex(), CREATEINDEX_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.attachToIndex(), ATTACHTOINDEX_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.detachFromIndex(), DETACHFROMINDEX_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.attachTypedLink(), ATTACHTYPEDLINK_BINDING);
            protocolMarshaller.marshall((Object)batchWriteOperation.detachTypedLink(), DETACHTYPEDLINK_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

