/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicy;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchLookupPolicyMarshaller {
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final BatchLookupPolicyMarshaller INSTANCE = new BatchLookupPolicyMarshaller();

    private BatchLookupPolicyMarshaller() {
    }

    public static BatchLookupPolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchLookupPolicy batchLookupPolicy, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchLookupPolicy, (String)"batchLookupPolicy");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchLookupPolicy.objectReference(), OBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)batchLookupPolicy.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)batchLookupPolicy.maxResults(), MAXRESULTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

