/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectPoliciesResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchListObjectPoliciesResponseMarshaller {
    private static final MarshallingInfo<List> ATTACHEDPOLICYIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttachedPolicyIds").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final BatchListObjectPoliciesResponseMarshaller INSTANCE = new BatchListObjectPoliciesResponseMarshaller();

    private BatchListObjectPoliciesResponseMarshaller() {
    }

    public static BatchListObjectPoliciesResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchListObjectPoliciesResponse batchListObjectPoliciesResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchListObjectPoliciesResponse, (String)"batchListObjectPoliciesResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchListObjectPoliciesResponse.attachedPolicyIds(), ATTACHEDPOLICYIDS_BINDING);
            protocolMarshaller.marshall((Object)batchListObjectPoliciesResponse.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

