/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchCreateObject;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchCreateObjectMarshaller {
    private static final MarshallingInfo<List> SCHEMAFACET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaFacet").isBinary(false).build();
    private static final MarshallingInfo<List> OBJECTATTRIBUTELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectAttributeList").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PARENTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentReference").isBinary(false).build();
    private static final MarshallingInfo<String> LINKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LinkName").isBinary(false).build();
    private static final MarshallingInfo<String> BATCHREFERENCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchReferenceName").isBinary(false).build();
    private static final BatchCreateObjectMarshaller INSTANCE = new BatchCreateObjectMarshaller();

    private BatchCreateObjectMarshaller() {
    }

    public static BatchCreateObjectMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchCreateObject batchCreateObject, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchCreateObject, (String)"batchCreateObject");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchCreateObject.schemaFacet(), SCHEMAFACET_BINDING);
            protocolMarshaller.marshall(batchCreateObject.objectAttributeList(), OBJECTATTRIBUTELIST_BINDING);
            protocolMarshaller.marshall((Object)batchCreateObject.parentReference(), PARENTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)batchCreateObject.linkName(), LINKNAME_BINDING);
            protocolMarshaller.marshall((Object)batchCreateObject.batchReferenceName(), BATCHREFERENCENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

