/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse;

public class LookupPolicyPublisher
implements SdkPublisher<LookupPolicyResponse> {
    private final CloudDirectoryAsyncClient client;
    private final LookupPolicyRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public LookupPolicyPublisher(CloudDirectoryAsyncClient client, LookupPolicyRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private LookupPolicyPublisher(CloudDirectoryAsyncClient client, LookupPolicyRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new LookupPolicyResponseFetcher();
    }

    public void subscribe(Subscriber<? super LookupPolicyResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final LookupPolicyPublisher resume(LookupPolicyResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new LookupPolicyPublisher(this.client, (LookupPolicyRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new LookupPolicyPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super LookupPolicyResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class LookupPolicyResponseFetcher
    implements AsyncPageFetcher<LookupPolicyResponse> {
        private LookupPolicyResponseFetcher() {
        }

        public boolean hasNextPage(LookupPolicyResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<LookupPolicyResponse> nextPage(LookupPolicyResponse previousPage) {
            if (previousPage == null) {
                return LookupPolicyPublisher.this.client.lookupPolicy(LookupPolicyPublisher.this.firstRequest);
            }
            return LookupPolicyPublisher.this.client.lookupPolicy((LookupPolicyRequest)((Object)LookupPolicyPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

