/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse;

public class ListTypedLinkFacetAttributesIterable
implements SdkIterable<ListTypedLinkFacetAttributesResponse> {
    private final CloudDirectoryClient client;
    private final ListTypedLinkFacetAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTypedLinkFacetAttributesIterable(CloudDirectoryClient client, ListTypedLinkFacetAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTypedLinkFacetAttributesResponseFetcher();
    }

    public Iterator<ListTypedLinkFacetAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListTypedLinkFacetAttributesIterable resume(ListTypedLinkFacetAttributesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTypedLinkFacetAttributesIterable(this.client, (ListTypedLinkFacetAttributesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTypedLinkFacetAttributesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTypedLinkFacetAttributesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTypedLinkFacetAttributesResponseFetcher
    implements SyncPageFetcher<ListTypedLinkFacetAttributesResponse> {
        private ListTypedLinkFacetAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListTypedLinkFacetAttributesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListTypedLinkFacetAttributesResponse nextPage(ListTypedLinkFacetAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListTypedLinkFacetAttributesIterable.this.client.listTypedLinkFacetAttributes(ListTypedLinkFacetAttributesIterable.this.firstRequest);
            }
            return ListTypedLinkFacetAttributesIterable.this.client.listTypedLinkFacetAttributes((ListTypedLinkFacetAttributesRequest)((Object)ListTypedLinkFacetAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

