/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse;

public class ListFacetAttributesPublisher
implements SdkPublisher<ListFacetAttributesResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListFacetAttributesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFacetAttributesPublisher(CloudDirectoryAsyncClient client, ListFacetAttributesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFacetAttributesPublisher(CloudDirectoryAsyncClient client, ListFacetAttributesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFacetAttributesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFacetAttributesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListFacetAttributesPublisher resume(ListFacetAttributesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListFacetAttributesPublisher(this.client, (ListFacetAttributesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListFacetAttributesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListFacetAttributesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListFacetAttributesResponseFetcher
    implements AsyncPageFetcher<ListFacetAttributesResponse> {
        private ListFacetAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListFacetAttributesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<ListFacetAttributesResponse> nextPage(ListFacetAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListFacetAttributesPublisher.this.client.listFacetAttributes(ListFacetAttributesPublisher.this.firstRequest);
            }
            return ListFacetAttributesPublisher.this.client.listFacetAttributes((ListFacetAttributesRequest)((Object)ListFacetAttributesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

