/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesResponse;

public class ListAttachedIndicesIterable
implements SdkIterable<ListAttachedIndicesResponse> {
    private final CloudDirectoryClient client;
    private final ListAttachedIndicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttachedIndicesIterable(CloudDirectoryClient client, ListAttachedIndicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttachedIndicesResponseFetcher();
    }

    public Iterator<ListAttachedIndicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListAttachedIndicesIterable resume(ListAttachedIndicesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAttachedIndicesIterable(this.client, (ListAttachedIndicesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListAttachedIndicesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAttachedIndicesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAttachedIndicesResponseFetcher
    implements SyncPageFetcher<ListAttachedIndicesResponse> {
        private ListAttachedIndicesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedIndicesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListAttachedIndicesResponse nextPage(ListAttachedIndicesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedIndicesIterable.this.client.listAttachedIndices(ListAttachedIndicesIterable.this.firstRequest);
            }
            return ListAttachedIndicesIterable.this.client.listAttachedIndices((ListAttachedIndicesRequest)((Object)ListAttachedIndicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

