/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttribute;
import software.amazon.awssdk.services.clouddirectory.model.UpdateActionType;
import software.amazon.awssdk.services.clouddirectory.transform.FacetAttributeUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FacetAttributeUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, FacetAttributeUpdate> {
    private final FacetAttribute attribute;
    private final String action;

    private FacetAttributeUpdate(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.action = builder.action;
    }

    public FacetAttribute attribute() {
        return this.attribute;
    }

    public UpdateActionType action() {
        return UpdateActionType.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttributeUpdate)) {
            return false;
        }
        FacetAttributeUpdate other = (FacetAttributeUpdate)obj;
        return Objects.equals(this.attribute(), other.attribute()) && Objects.equals(this.actionAsString(), other.actionAsString());
    }

    public String toString() {
        return ToString.builder((String)"FacetAttributeUpdate").add("Attribute", (Object)this.attribute()).add("Action", (Object)this.actionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attribute()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FacetAttributeUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private FacetAttribute attribute;
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(FacetAttributeUpdate model) {
            this.attribute(model.attribute);
            this.action(model.action);
        }

        public final FacetAttribute.Builder getAttribute() {
            return this.attribute != null ? this.attribute.toBuilder() : null;
        }

        @Override
        public final Builder attribute(FacetAttribute attribute) {
            this.attribute = attribute;
            return this;
        }

        public final void setAttribute(FacetAttribute.BuilderImpl attribute) {
            this.attribute = attribute != null ? attribute.build() : null;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(UpdateActionType action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public FacetAttributeUpdate build() {
            return new FacetAttributeUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FacetAttributeUpdate> {
        public Builder attribute(FacetAttribute var1);

        default public Builder attribute(Consumer<FacetAttribute.Builder> attribute) {
            return this.attribute((FacetAttribute)((FacetAttribute.Builder)FacetAttribute.builder().applyMutation(attribute)).build());
        }

        public Builder action(String var1);

        public Builder action(UpdateActionType var1);
    }
}

