/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.transform.BatchDetachFromIndexMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetachFromIndex
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchDetachFromIndex> {
    private final ObjectReference indexReference;
    private final ObjectReference targetReference;

    private BatchDetachFromIndex(BuilderImpl builder) {
        this.indexReference = builder.indexReference;
        this.targetReference = builder.targetReference;
    }

    public ObjectReference indexReference() {
        return this.indexReference;
    }

    public ObjectReference targetReference() {
        return this.targetReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReference());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetachFromIndex)) {
            return false;
        }
        BatchDetachFromIndex other = (BatchDetachFromIndex)obj;
        return Objects.equals(this.indexReference(), other.indexReference()) && Objects.equals(this.targetReference(), other.targetReference());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetachFromIndex").add("IndexReference", (Object)this.indexReference()).add("TargetReference", (Object)this.targetReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexReference": {
                return Optional.ofNullable(clazz.cast(this.indexReference()));
            }
            case "TargetReference": {
                return Optional.ofNullable(clazz.cast(this.targetReference()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchDetachFromIndexMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference indexReference;
        private ObjectReference targetReference;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetachFromIndex model) {
            this.indexReference(model.indexReference);
            this.targetReference(model.targetReference);
        }

        public final ObjectReference.Builder getIndexReference() {
            return this.indexReference != null ? this.indexReference.toBuilder() : null;
        }

        @Override
        public final Builder indexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
            return this;
        }

        public final void setIndexReference(ObjectReference.BuilderImpl indexReference) {
            this.indexReference = indexReference != null ? indexReference.build() : null;
        }

        public final ObjectReference.Builder getTargetReference() {
            return this.targetReference != null ? this.targetReference.toBuilder() : null;
        }

        @Override
        public final Builder targetReference(ObjectReference targetReference) {
            this.targetReference = targetReference;
            return this;
        }

        public final void setTargetReference(ObjectReference.BuilderImpl targetReference) {
            this.targetReference = targetReference != null ? targetReference.build() : null;
        }

        public BatchDetachFromIndex build() {
            return new BatchDetachFromIndex(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchDetachFromIndex> {
        public Builder indexReference(ObjectReference var1);

        default public Builder indexReference(Consumer<ObjectReference.Builder> indexReference) {
            return this.indexReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(indexReference)).build());
        }

        public Builder targetReference(ObjectReference var1);

        default public Builder targetReference(Consumer<ObjectReference.Builder> targetReference) {
            return this.targetReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(targetReference)).build());
        }
    }
}

