/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacetListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.BatchCreateObjectMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateObject
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchCreateObject> {
    private final List<SchemaFacet> schemaFacet;
    private final List<AttributeKeyAndValue> objectAttributeList;
    private final ObjectReference parentReference;
    private final String linkName;
    private final String batchReferenceName;

    private BatchCreateObject(BuilderImpl builder) {
        this.schemaFacet = builder.schemaFacet;
        this.objectAttributeList = builder.objectAttributeList;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
        this.batchReferenceName = builder.batchReferenceName;
    }

    public List<SchemaFacet> schemaFacet() {
        return this.schemaFacet;
    }

    public List<AttributeKeyAndValue> objectAttributeList() {
        return this.objectAttributeList;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public String linkName() {
        return this.linkName;
    }

    public String batchReferenceName() {
        return this.batchReferenceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaFacet());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectAttributeList());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchReferenceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateObject)) {
            return false;
        }
        BatchCreateObject other = (BatchCreateObject)obj;
        return Objects.equals(this.schemaFacet(), other.schemaFacet()) && Objects.equals(this.objectAttributeList(), other.objectAttributeList()) && Objects.equals(this.parentReference(), other.parentReference()) && Objects.equals(this.linkName(), other.linkName()) && Objects.equals(this.batchReferenceName(), other.batchReferenceName());
    }

    public String toString() {
        return ToString.builder((String)"BatchCreateObject").add("SchemaFacet", this.schemaFacet()).add("ObjectAttributeList", this.objectAttributeList()).add("ParentReference", (Object)this.parentReference()).add("LinkName", (Object)this.linkName()).add("BatchReferenceName", (Object)this.batchReferenceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaFacet": {
                return Optional.ofNullable(clazz.cast(this.schemaFacet()));
            }
            case "ObjectAttributeList": {
                return Optional.ofNullable(clazz.cast(this.objectAttributeList()));
            }
            case "ParentReference": {
                return Optional.ofNullable(clazz.cast(this.parentReference()));
            }
            case "LinkName": {
                return Optional.ofNullable(clazz.cast(this.linkName()));
            }
            case "BatchReferenceName": {
                return Optional.ofNullable(clazz.cast(this.batchReferenceName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchCreateObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SchemaFacet> schemaFacet = DefaultSdkAutoConstructList.getInstance();
        private List<AttributeKeyAndValue> objectAttributeList = DefaultSdkAutoConstructList.getInstance();
        private ObjectReference parentReference;
        private String linkName;
        private String batchReferenceName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateObject model) {
            this.schemaFacet(model.schemaFacet);
            this.objectAttributeList(model.objectAttributeList);
            this.parentReference(model.parentReference);
            this.linkName(model.linkName);
            this.batchReferenceName(model.batchReferenceName);
        }

        public final Collection<SchemaFacet.Builder> getSchemaFacet() {
            return this.schemaFacet != null ? (Collection)this.schemaFacet.stream().map(SchemaFacet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemaFacet(Collection<SchemaFacet> schemaFacet) {
            this.schemaFacet = SchemaFacetListCopier.copy(schemaFacet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacet(SchemaFacet ... schemaFacet) {
            this.schemaFacet(Arrays.asList(schemaFacet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacet(Consumer<SchemaFacet.Builder> ... schemaFacet) {
            this.schemaFacet(Stream.of(schemaFacet).map(c -> (SchemaFacet)((SchemaFacet.Builder)SchemaFacet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSchemaFacet(Collection<SchemaFacet.BuilderImpl> schemaFacet) {
            this.schemaFacet = SchemaFacetListCopier.copyFromBuilder(schemaFacet);
        }

        public final Collection<AttributeKeyAndValue.Builder> getObjectAttributeList() {
            return this.objectAttributeList != null ? (Collection)this.objectAttributeList.stream().map(AttributeKeyAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
            this.objectAttributeList(Arrays.asList(objectAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder> ... objectAttributeList) {
            this.objectAttributeList(Stream.of(objectAttributeList).map(c -> (AttributeKeyAndValue)((AttributeKeyAndValue.Builder)AttributeKeyAndValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setObjectAttributeList(Collection<AttributeKeyAndValue.BuilderImpl> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copyFromBuilder(objectAttributeList);
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public final String getBatchReferenceName() {
            return this.batchReferenceName;
        }

        @Override
        public final Builder batchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
            return this;
        }

        public final void setBatchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
        }

        public BatchCreateObject build() {
            return new BatchCreateObject(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchCreateObject> {
        public Builder schemaFacet(Collection<SchemaFacet> var1);

        public Builder schemaFacet(SchemaFacet ... var1);

        public Builder schemaFacet(Consumer<SchemaFacet.Builder> ... var1);

        public Builder objectAttributeList(Collection<AttributeKeyAndValue> var1);

        public Builder objectAttributeList(AttributeKeyAndValue ... var1);

        public Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder> ... var1);

        public Builder parentReference(ObjectReference var1);

        default public Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return this.parentReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(parentReference)).build());
        }

        public Builder linkName(String var1);

        public Builder batchReferenceName(String var1);
    }
}

