/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListObjectChildrenRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<String> CONSISTENCYLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-consistency-level").isBinary(false).build();
    private static final ListObjectChildrenRequestModelMarshaller INSTANCE = new ListObjectChildrenRequestModelMarshaller();

    private ListObjectChildrenRequestModelMarshaller() {
    }

    public static ListObjectChildrenRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListObjectChildrenRequest listObjectChildrenRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listObjectChildrenRequest), (String)"listObjectChildrenRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listObjectChildrenRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)listObjectChildrenRequest.objectReference(), OBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)listObjectChildrenRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listObjectChildrenRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listObjectChildrenRequest.consistencyLevelAsString(), CONSISTENCYLEVEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

