/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObject;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchAddFacetToObjectMarshaller {
    private static final MarshallingInfo<StructuredPojo> SCHEMAFACET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaFacet").isBinary(false).build();
    private static final MarshallingInfo<List> OBJECTATTRIBUTELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectAttributeList").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").isBinary(false).build();
    private static final BatchAddFacetToObjectMarshaller INSTANCE = new BatchAddFacetToObjectMarshaller();

    private BatchAddFacetToObjectMarshaller() {
    }

    public static BatchAddFacetToObjectMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchAddFacetToObject batchAddFacetToObject, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchAddFacetToObject, (String)"batchAddFacetToObject");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchAddFacetToObject.schemaFacet(), SCHEMAFACET_BINDING);
            protocolMarshaller.marshall(batchAddFacetToObject.objectAttributeList(), OBJECTATTRIBUTELIST_BINDING);
            protocolMarshaller.marshall((Object)batchAddFacetToObject.objectReference(), OBJECTREFERENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

