/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.PolicyToPath;
import software.amazon.awssdk.services.clouddirectory.model.PolicyToPathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LookupPolicyResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, LookupPolicyResponse> {
    private final List<PolicyToPath> policyToPathList;
    private final String nextToken;

    private LookupPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyToPathList = builder.policyToPathList;
        this.nextToken = builder.nextToken;
    }

    public List<PolicyToPath> policyToPathList() {
        return this.policyToPathList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyToPathList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupPolicyResponse)) {
            return false;
        }
        LookupPolicyResponse other = (LookupPolicyResponse)((Object)obj);
        return Objects.equals(this.policyToPathList(), other.policyToPathList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"LookupPolicyResponse").add("PolicyToPathList", this.policyToPathList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyToPathList": {
                return Optional.of(clazz.cast(this.policyToPathList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<PolicyToPath> policyToPathList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupPolicyResponse model) {
            super(model);
            this.policyToPathList(model.policyToPathList);
            this.nextToken(model.nextToken);
        }

        public final Collection<PolicyToPath.Builder> getPolicyToPathList() {
            return this.policyToPathList != null ? (Collection)this.policyToPathList.stream().map(PolicyToPath::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyToPathList(Collection<PolicyToPath> policyToPathList) {
            this.policyToPathList = PolicyToPathListCopier.copy(policyToPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyToPathList(PolicyToPath ... policyToPathList) {
            this.policyToPathList(Arrays.asList(policyToPathList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyToPathList(Consumer<PolicyToPath.Builder> ... policyToPathList) {
            this.policyToPathList(Stream.of(policyToPathList).map(c -> (PolicyToPath)((PolicyToPath.Builder)PolicyToPath.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyToPathList(Collection<PolicyToPath.BuilderImpl> policyToPathList) {
            this.policyToPathList = PolicyToPathListCopier.copyFromBuilder(policyToPathList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public LookupPolicyResponse build() {
            return new LookupPolicyResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, LookupPolicyResponse> {
        public Builder policyToPathList(Collection<PolicyToPath> var1);

        public Builder policyToPathList(PolicyToPath ... var1);

        public Builder policyToPathList(Consumer<PolicyToPath.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

